/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Server;
import com.ibm.as400.access.BaseDataQueueImpl;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DQClearDataStream;
import com.ibm.as400.access.DQCommonReplyDataStream;
import com.ibm.as400.access.DQCreateDataStream;
import com.ibm.as400.access.DQDeleteDataStream;
import com.ibm.as400.access.DQExchangeAttributesDataStream;
import com.ibm.as400.access.DQExchangeAttributesNormalReplyDataStream;
import com.ibm.as400.access.DQQueryRecord;
import com.ibm.as400.access.DQReadDataStream;
import com.ibm.as400.access.DQReadNormalReplyDataStream;
import com.ibm.as400.access.DQReceiveRecord;
import com.ibm.as400.access.DQRequestAttributesDataStream;
import com.ibm.as400.access.DQRequestAttributesNormalReplyDataStream;
import com.ibm.as400.access.DQWriteDataStream;
import com.ibm.as400.access.DataStream;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.IllegalObjectTypeException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ObjectAlreadyExistsException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.Trace;
import java.io.IOException;

class BaseDataQueueImplRemote
implements BaseDataQueueImpl {
    AS400ImplRemote system_;
    private AS400Server server_ = null;
    String path_;
    ConverterImplRemote converter_;
    byte[] queueNameBytes_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
    byte[] libraryBytes_ = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64};

    BaseDataQueueImplRemote() {
    }

    @Override
    public void setSystemAndPath(AS400Impl system, String path, String name, String library) throws IOException {
        if (Trace.traceOn_) {
            Trace.log(1, "Setting up implementation object: " + path);
        }
        this.system_ = (AS400ImplRemote)system;
        this.path_ = path;
        this.converter_ = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
        this.converter_.stringToByteArray(name, this.queueNameBytes_);
        this.converter_.stringToByteArray(library, this.libraryBytes_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void open() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        AS400Server aS400Server = this.server_ = this.system_.getConnection(3, false, false);
        synchronized (aS400Server) {
            DataStream baseReply = this.server_.getExchangeAttrReply();
            if (baseReply == null) {
                try {
                    baseReply = this.server_.sendExchangeAttrRequest(new DQExchangeAttributesDataStream());
                }
                catch (IOException e) {
                    Trace.log(2, "IOException during exchange attributes:", (Throwable)e);
                    this.system_.disconnectServer(this.server_);
                    throw e;
                }
                switch (baseReply.hashCode()) {
                    case 32768: {
                        return;
                    }
                    case 32770: {
                        Trace.log(2, "Unexpected reply datastream:", baseReply.data_);
                        this.system_.disconnectServer(this.server_);
                        DQCommonReplyDataStream reply = (DQCommonReplyDataStream)baseReply;
                        throw this.buildException(reply.getRC(), reply.getMessage());
                    }
                }
                Trace.log(2, "Unknown exchange attributes reply datastream:", baseReply.data_);
                this.system_.disconnectServer(this.server_);
                throw new InternalErrorException(2);
            }
        }
    }

    @Override
    public void clear(byte[] key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing clear: " + this.path_);
        }
        DQClearDataStream request = new DQClearDataStream(this.queueNameBytes_, this.libraryBytes_, key);
        try {
            DataStream baseReply = this.server_.sendAndReceive(request);
            switch (baseReply.hashCode()) {
                case 32770: {
                    DQCommonReplyDataStream reply = (DQCommonReplyDataStream)baseReply;
                    int rc = reply.getRC();
                    if (rc != 61440) {
                        throw this.buildException(key != null, rc, reply.getMessage());
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Unknown clear reply datastream:", baseReply.data_);
                    throw new InternalErrorException(2);
                }
            }
        }
        catch (IOException e) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            throw e;
        }
    }

    @Override
    public void create(int maxEntryLength, String authority, boolean saveSenderInformation, boolean FIFO, int keyLength, boolean forceToAuxiliaryStorage, String description) throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectAlreadyExistsException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing create: " + this.path_);
        }
        byte[] descriptionBytes = new byte[]{64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64, 64};
        this.converter_.stringToByteArray(description, descriptionBytes);
        DQCreateDataStream request = new DQCreateDataStream(this.queueNameBytes_, this.libraryBytes_, maxEntryLength, authority, saveSenderInformation, FIFO, keyLength, forceToAuxiliaryStorage, descriptionBytes);
        try {
            DataStream baseReply = this.server_.sendAndReceive(request);
            switch (baseReply.hashCode()) {
                case 32770: {
                    DQCommonReplyDataStream reply = (DQCommonReplyDataStream)baseReply;
                    int rc = reply.getRC();
                    if (rc != 61440) {
                        if (rc == 61441 && this.converter_.byteArrayToString(reply.getMessage(), 0, 7).equals("CPF9870")) {
                            Trace.log(2, "Data queue already exists: " + this.path_);
                            throw new ObjectAlreadyExistsException(this.path_, 1);
                        }
                        throw this.buildException(rc, reply.getMessage());
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Unknown create reply datastream:", baseReply.data_);
                    throw new InternalErrorException(2);
                }
            }
        }
        catch (IOException e) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            throw e;
        }
    }

    @Override
    public void delete() throws AS400SecurityException, ErrorCompletingRequestException, IOException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing delete: " + this.path_);
        }
        DQDeleteDataStream request = new DQDeleteDataStream(this.queueNameBytes_, this.libraryBytes_);
        try {
            DataStream baseReply = this.server_.sendAndReceive(request);
            switch (baseReply.hashCode()) {
                case 32770: {
                    DQCommonReplyDataStream reply = (DQCommonReplyDataStream)baseReply;
                    int rc = reply.getRC();
                    if (rc != 61440) {
                        throw this.buildException(rc, reply.getMessage());
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Unknown delete reply datastream:", baseReply.data_);
                    throw new InternalErrorException(2);
                }
            }
        }
        catch (IOException e) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            throw e;
        }
    }

    @Override
    public DQReceiveRecord read(String search, int wait, boolean peek, byte[] key) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing read: " + this.path_);
        }
        byte[] searchBytes = key == null ? new byte[2] : this.converter_.stringToByteArray(search);
        DQReadDataStream request = new DQReadDataStream(this.queueNameBytes_, this.libraryBytes_, searchBytes, wait, peek, key);
        try {
            DataStream baseReply = this.server_.sendAndReceive(request);
            switch (baseReply.hashCode()) {
                case 32771: {
                    DQReadNormalReplyDataStream reply = (DQReadNormalReplyDataStream)baseReply;
                    byte[] senderInformationBytes = reply.getSenderInformation();
                    return new DQReceiveRecord(senderInformationBytes[0] == 64 ? null : this.converter_.byteArrayToString(senderInformationBytes), reply.getEntry(), reply.getKey());
                }
                case 32770: {
                    DQCommonReplyDataStream commonReply = (DQCommonReplyDataStream)baseReply;
                    int rc = commonReply.getRC();
                    if (rc == 61446) {
                        Trace.log(3, "No entry on data queue.");
                        return null;
                    }
                    throw this.buildException(key != null, rc, commonReply.getMessage());
                }
            }
            Trace.log(2, "Unknown read reply datastream ", baseReply.data_);
            throw new InternalErrorException(2);
        }
        catch (IOException e) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            throw e;
        }
    }

    @Override
    public DQQueryRecord retrieveAttributes(boolean keyed) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing retrieve attributes: " + this.path_);
        }
        DQRequestAttributesDataStream request = new DQRequestAttributesDataStream(this.queueNameBytes_, this.libraryBytes_);
        try {
            DataStream baseReply = this.server_.sendAndReceive(request);
            switch (baseReply.hashCode()) {
                case 32769: {
                    DQRequestAttributesNormalReplyDataStream reply = (DQRequestAttributesNormalReplyDataStream)baseReply;
                    int type = reply.getType();
                    DQQueryRecord record = new DQQueryRecord();
                    if (keyed) {
                        if (type != 2) {
                            Trace.log(2, "Using KeyedDataQueue for non-keyed data queue: " + this.path_);
                            throw new IllegalObjectTypeException(this.path_, 2);
                        }
                        record.FIFO_ = true;
                    } else if (type == 0) {
                        record.FIFO_ = true;
                    } else if (type == 1) {
                        record.FIFO_ = false;
                    } else {
                        Trace.log(2, "Using DataQueue for keyed data queue: " + this.path_);
                        throw new IllegalObjectTypeException(this.path_, 1);
                    }
                    record.maxEntryLength_ = reply.getMaxEntryLength();
                    record.saveSenderInformation_ = reply.getSaveSenderInformation();
                    record.forceToAuxiliaryStorage_ = reply.getForceToAuxiliaryStorage();
                    record.description_ = this.converter_.byteArrayToString(reply.getDescription());
                    record.keyLength_ = reply.getKeyLength();
                    return record;
                }
                case 32770: {
                    DQCommonReplyDataStream commonReply = (DQCommonReplyDataStream)baseReply;
                    throw this.buildException(commonReply.getRC(), commonReply.getMessage());
                }
            }
            Trace.log(2, "Unknown retrieve attributes reply datastream:", baseReply.data_);
            throw new InternalErrorException(2);
        }
        catch (IOException e) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            throw e;
        }
    }

    @Override
    public void write(byte[] key, byte[] data) throws AS400SecurityException, ErrorCompletingRequestException, IOException, IllegalObjectTypeException, InterruptedException, ObjectDoesNotExistException {
        this.open();
        if (Trace.traceOn_) {
            Trace.log(1, "Processing write: " + this.path_);
        }
        DQWriteDataStream request = new DQWriteDataStream(this.queueNameBytes_, this.libraryBytes_, key, data);
        try {
            DataStream baseReply = this.server_.sendAndReceive(request);
            switch (baseReply.hashCode()) {
                case 32770: {
                    DQCommonReplyDataStream reply = (DQCommonReplyDataStream)baseReply;
                    int rc = reply.getRC();
                    if (rc != 61440) {
                        throw this.buildException(key != null, rc, reply.getMessage());
                    }
                    break;
                }
                default: {
                    Trace.log(2, "Unknown write reply datastream:", baseReply.data_);
                    throw new InternalErrorException(2);
                }
            }
        }
        catch (IOException e) {
            Trace.log(2, "Lost connection to data queue server:", (Throwable)e);
            this.system_.disconnectServer(this.server_);
            throw e;
        }
    }

    private AS400Exception buildException(int rc, byte[] messageBytes) throws AS400SecurityException, ErrorCompletingRequestException, ObjectDoesNotExistException {
        switch (rc) {
            case 61441: {
                if (messageBytes == null) {
                    Trace.log(2, "Error completing data queue request, rc: 0xF001");
                    throw new ErrorCompletingRequestException(11, rc + ":");
                }
                String messageID = this.converter_.byteArrayToString(messageBytes, 0, 7);
                String message = this.converter_.byteArrayToString(messageBytes);
                Trace.log(2, "Error completing data queue request: " + message);
                if (messageID.equals("CPF9810")) {
                    Trace.log(2, "Library does not exist: '" + this.converter_.byteArrayToString(this.libraryBytes_) + "'");
                    throw new ObjectDoesNotExistException(this.path_, 1);
                }
                if (messageID.equals("CPF9801") || messageID.equals("CPF2105")) {
                    throw new ObjectDoesNotExistException(this.path_, 2);
                }
                if (messageID.equals("CPF9802") || messageID.equals("CPF2189")) {
                    throw new AS400SecurityException(this.path_, 4);
                }
                if (messageID.equals("CPF9820") || messageID.equals("CPF2182")) {
                    throw new AS400SecurityException(this.path_, 3);
                }
                return new AS400Exception(new AS400Message(messageID, message.substring(9)));
            }
            case 61442: {
                Trace.log(2, "Data queue protocol error.");
                throw new InternalErrorException(4);
            }
            case 61443: {
                Trace.log(2, "Data queue syntax error.");
                throw new InternalErrorException(5);
            }
            case 61444: {
                Trace.log(2, "Data queue has been destroyed.");
                throw new ObjectDoesNotExistException(this.path_, 2);
            }
            case 61445: {
                Trace.log(2, "Unsupported length.");
                throw new ErrorCompletingRequestException(9);
            }
            case 61447: {
                Trace.log(2, "Data queue data stream level not valid.");
                throw new InternalErrorException(1);
            }
            case 61448: {
                Trace.log(2, "Data queue VRM not valid.");
                throw new InternalErrorException(7);
            }
            case 61449: {
                Trace.log(2, "Exit program rejected request.");
                throw new ErrorCompletingRequestException(4);
            }
            case 61450: {
                Trace.log(2, "Exit program not authorized.");
                throw new AS400SecurityException(2);
            }
            case 61451: {
                Trace.log(2, "Exit program not found.");
                throw new ErrorCompletingRequestException(6);
            }
            case 61453: {
                Trace.log(2, "Exit program error.");
                throw new ErrorCompletingRequestException(5);
            }
            case 61454: {
                Trace.log(2, "Exit program number not valid.");
                throw new ErrorCompletingRequestException(7);
            }
        }
        byte[] rcBytes = new byte[2];
        BinaryConverter.unsignedShortToByteArray(rc, rcBytes, 0);
        if (messageBytes == null) {
            Trace.log(2, "Error completing data queue request, rc:", rcBytes);
            throw new ErrorCompletingRequestException(11, rc + ":");
        }
        String message = this.converter_.byteArrayToString(messageBytes);
        Trace.log(2, "Error completing data queue request: " + message + ", rc:", rcBytes);
        throw new ErrorCompletingRequestException(11, rc + " : " + message);
    }

    private AS400Exception buildException(boolean expectKeyed, int rc, byte[] messageBytes) throws AS400SecurityException, ErrorCompletingRequestException, IllegalObjectTypeException, ObjectDoesNotExistException {
        if (rc == 61441 && messageBytes != null) {
            String messageID = this.converter_.byteArrayToString(messageBytes, 0, 7);
            if (expectKeyed && messageID.equals("CPF9502")) {
                Trace.log(2, "Error completing data queue request: " + this.converter_.byteArrayToString(messageBytes));
                Trace.log(2, "Using KeyedDataQueue for non-keyed data queue: " + this.path_);
                throw new IllegalObjectTypeException(this.path_, 2);
            }
            if (!expectKeyed && messageID.equals("CPF9506")) {
                Trace.log(2, "Error completing data queue request: " + this.converter_.byteArrayToString(messageBytes));
                Trace.log(2, "Using DataQueue for keyed data queue: " + this.path_);
                throw new IllegalObjectTypeException(this.path_, 1);
            }
        }
        return this.buildException(rc, messageBytes);
    }

    static {
        AS400Server.addReplyStream((DataStream)new DQExchangeAttributesNormalReplyDataStream(), 3);
        AS400Server.addReplyStream((DataStream)new DQRequestAttributesNormalReplyDataStream(), 3);
        AS400Server.addReplyStream((DataStream)new DQCommonReplyDataStream(), 3);
        AS400Server.addReplyStream((DataStream)new DQReadNormalReplyDataStream(), 3);
    }
}

