/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.calculator;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.calculator.Calculator;
import org.apache.hop.pipeline.transforms.calculator.CalculatorData;
import org.apache.hop.pipeline.transforms.calculator.CalculatorMetaFunction;

@Transform(id="Calculator", image="calculator.svg", name="i18n::BaseTransform.TypeLongDesc.Calculator", description="i18n::BaseTransform.TypeTooltipDesc.Calculator", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", keywords={"i18n::CalculatorMeta.keyword"}, documentationUrl="/pipeline/transforms/calculator.html")
public class CalculatorMeta
extends BaseTransformMeta<Calculator, CalculatorData> {
    private static final Class<?> PKG = CalculatorMeta.class;
    @HopMetadataProperty(key="calculation", injectionGroupKey="Calculations", injectionGroupDescription="CalculatorMeta.Injection.Calculations")
    private List<CalculatorMetaFunction> functions = new ArrayList<CalculatorMetaFunction>();
    @HopMetadataProperty(injectionKeyDescription="CalculatorMeta.Injection.FailIfNoFile")
    private boolean failIfNoFile = true;

    public CalculatorMeta clone() {
        CalculatorMeta meta = new CalculatorMeta();
        meta.setFailIfNoFile(this.isFailIfNoFile());
        for (CalculatorMetaFunction function : this.functions) {
            meta.getFunctions().add(new CalculatorMetaFunction(function));
        }
        return meta;
    }

    public void getFields(IRowMeta row, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (CalculatorMetaFunction calculation : this.functions) {
            if (calculation.isRemovedFromResult() || Utils.isEmpty((CharSequence)calculation.getFieldName())) continue;
            IValueMeta v = this.getValueMeta(calculation, origin);
            row.addValueMeta(v);
        }
    }

    private IValueMeta getValueMeta(CalculatorMetaFunction fn, String origin) {
        IValueMeta v;
        int defaultResultType = ValueMetaFactory.getIdForValueMeta((String)fn.getValueType());
        if (defaultResultType == 0) {
            defaultResultType = fn.getCalcType().calculation.getDefaultResultType();
        }
        try {
            v = ValueMetaFactory.createValueMeta((String)fn.getFieldName(), (int)defaultResultType);
        }
        catch (Exception ex) {
            return null;
        }
        v.setLength(fn.getValueLength());
        v.setPrecision(fn.getValuePrecision());
        v.setOrigin(origin);
        v.setComments(fn.getCalcType().getDescription());
        v.setConversionMask(fn.getConversionMask());
        v.setDecimalSymbol(fn.getDecimalSymbol());
        v.setGroupingSymbol(fn.getGroupingSymbol());
        v.setCurrencySymbol(fn.getCurrencySymbol());
        return v;
    }

    public IRowMeta getAllFields(IRowMeta inputRowMeta) {
        IRowMeta rowMeta = inputRowMeta.clone();
        for (CalculatorMetaFunction calculation : this.getFunctions()) {
            if (Utils.isEmpty((CharSequence)calculation.getFieldName())) continue;
            IValueMeta v = this.getValueMeta(calculation, null);
            rowMeta.addValueMeta(v);
        }
        return rowMeta;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CalculatorMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            if (prev == null || prev.isEmpty()) {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CalculatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CalculatorMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CalculatorMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    @Generated
    public List<CalculatorMetaFunction> getFunctions() {
        return this.functions;
    }

    @Generated
    public boolean isFailIfNoFile() {
        return this.failIfNoFile;
    }

    @Generated
    public void setFunctions(List<CalculatorMetaFunction> functions) {
        this.functions = functions;
    }

    @Generated
    public void setFailIfNoFile(boolean failIfNoFile) {
        this.failIfNoFile = failIfNoFile;
    }
}

