/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import lombok.Generated;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.gui.IGuiPosition;
import org.apache.hop.core.gui.IGuiSize;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.serializer.xml.XmlMetadataUtil;
import org.w3c.dom.Node;

public class NotePadMeta
implements Cloneable,
IGuiPosition,
IGuiSize {
    public static final String XML_TAG = "notepad";
    public static final int COLOR_RGB_BLACK_RED = 14;
    public static final int COLOR_RGB_BLACK_GREEN = 58;
    public static final int COLOR_RGB_BLACK_BLUE = 90;
    public static final int COLOR_RGB_DEFAULT_BG_RED = 201;
    public static final int COLOR_RGB_DEFAULT_BG_GREEN = 232;
    public static final int COLOR_RGB_DEFAULT_BG_BLUE = 251;
    public static final int COLOR_RGB_DEFAULT_BORDER_RED = 14;
    public static final int COLOR_RGB_DEFAULT_BORDER_GREEN = 58;
    public static final int COLOR_RGB_DEFAULT_BORDER_BLUE = 90;
    @HopMetadataProperty
    private String note;
    @HopMetadataProperty(key="fontname")
    private String fontName;
    @HopMetadataProperty(key="fontsize")
    private int fontSize;
    @HopMetadataProperty(key="fontbold")
    private boolean fontBold;
    @HopMetadataProperty(key="fontitalic")
    private boolean fontItalic;
    @HopMetadataProperty(key="fontcolorred")
    private int fontColorRed;
    @HopMetadataProperty(key="fontcolorgreen")
    private int fontColorGreen;
    @HopMetadataProperty(key="fontcolorblue")
    private int fontColorBlue;
    @HopMetadataProperty(key="backgroundcolorred")
    private int backGroundColorRed;
    @HopMetadataProperty(key="backgroundcolorgreen")
    private int backGroundColorGreen;
    @HopMetadataProperty(key="backgroundcolorblue")
    private int backGroundColorBlue;
    @HopMetadataProperty(key="bordercolorred")
    private int borderColorRed;
    @HopMetadataProperty(key="bordercolorgreen")
    private int borderColorGreen;
    @HopMetadataProperty(key="bordercolorblue")
    private int borderColorBlue;
    @HopMetadataProperty(inline=true)
    private Point location;
    @HopMetadataProperty
    public int width;
    @HopMetadataProperty
    public int height;
    private int minimumWidth;
    private int minimumHeight;
    private boolean selected;
    private boolean changed;

    public NotePadMeta() {
        this.note = null;
        this.location = new Point(-1, -1);
        this.width = -1;
        this.height = -1;
        this.selected = false;
        this.setDefaultFont();
    }

    public NotePadMeta(String note, int locationX, int locationY, int width, int height) {
        this();
        this.note = note;
        this.location = new Point(locationX, locationY);
        this.width = width;
        this.height = height;
    }

    public NotePadMeta(String note, int x, int y, int width, int height, String fontName, int fontSize, boolean fontBold, boolean fontItalic, int fontColorRed, int fontColorGreen, int fontColorBlue, int backGroundColorRed, int backGroundColorGreen, int backGroundColorBlue, int borderColorRed, int borderColorGreen, int borderColorBlue) {
        this.note = note;
        this.location = new Point(x, y);
        this.width = width;
        this.height = height;
        this.selected = false;
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.fontBold = fontBold;
        this.fontItalic = fontItalic;
        this.fontColorRed = fontColorRed;
        this.fontColorGreen = fontColorGreen;
        this.fontColorBlue = fontColorBlue;
        this.backGroundColorRed = backGroundColorRed;
        this.backGroundColorGreen = backGroundColorGreen;
        this.backGroundColorBlue = backGroundColorBlue;
        this.borderColorRed = borderColorRed;
        this.borderColorGreen = borderColorGreen;
        this.borderColorBlue = borderColorBlue;
    }

    public NotePadMeta(NotePadMeta n) {
        this(n.note, n.location.x, n.location.y, n.width, n.height, n.fontName, n.fontSize, n.fontBold, n.fontItalic, n.fontColorRed, n.fontColorGreen, n.fontColorBlue, n.backGroundColorRed, n.backGroundColorGreen, n.backGroundColorBlue, n.borderColorRed, n.borderColorGreen, n.borderColorBlue);
    }

    public NotePadMeta(Node nodePadNode) throws HopXmlException {
        this();
        try {
            XmlMetadataUtil.deSerializeFromXml((Node)nodePadNode, NotePadMeta.class, (Object)this, null);
        }
        catch (Exception e) {
            throw new HopXmlException("Unable to read Notepad metadata from XML", (Throwable)e);
        }
    }

    public String getXml() {
        try {
            return XmlHandler.openTag((String)XML_TAG) + XmlMetadataUtil.serializeObjectToXml((Object)this) + XmlHandler.closeTag((String)XML_TAG);
        }
        catch (Exception e) {
            throw new RuntimeException("Error serializing notepad metadata to XML", e);
        }
    }

    public void setLocation(int x, int y) {
        if (x != this.location.x || y != this.location.y) {
            this.setChanged();
        }
        this.location.x = x;
        this.location.y = y;
    }

    public void setLocation(Point point) {
        if (point != null) {
            this.setLocation(point.x, point.y);
        } else {
            this.location = null;
        }
    }

    public Point getLocation() {
        return this.location;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void flipSelected() {
        this.selected = !this.selected;
    }

    public NotePadMeta clone() {
        return new NotePadMeta(this);
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public String toString() {
        return this.note;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        if (this.height != height) {
            this.setChanged();
        }
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        if (this.width != width) {
            this.setChanged();
        }
        this.width = width;
    }

    private void setDefaultFont() {
        this.fontName = null;
        this.fontSize = -1;
        this.fontBold = false;
        this.fontItalic = false;
        this.fontColorRed = 14;
        this.fontColorGreen = 58;
        this.fontColorBlue = 90;
        this.backGroundColorRed = 201;
        this.backGroundColorGreen = 232;
        this.backGroundColorBlue = 251;
        this.borderColorRed = 14;
        this.borderColorGreen = 58;
        this.borderColorBlue = 90;
    }

    @Generated
    public void setNote(String note) {
        this.note = note;
    }

    @Generated
    public String getNote() {
        return this.note;
    }

    @Generated
    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    @Generated
    public String getFontName() {
        return this.fontName;
    }

    @Generated
    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    @Generated
    public int getFontSize() {
        return this.fontSize;
    }

    @Generated
    public boolean isFontBold() {
        return this.fontBold;
    }

    @Generated
    public void setFontBold(boolean fontBold) {
        this.fontBold = fontBold;
    }

    @Generated
    public boolean isFontItalic() {
        return this.fontItalic;
    }

    @Generated
    public void setFontItalic(boolean fontItalic) {
        this.fontItalic = fontItalic;
    }

    @Generated
    public int getFontColorRed() {
        return this.fontColorRed;
    }

    @Generated
    public void setFontColorRed(int fontColorRed) {
        this.fontColorRed = fontColorRed;
    }

    @Generated
    public int getFontColorGreen() {
        return this.fontColorGreen;
    }

    @Generated
    public void setFontColorGreen(int fontColorGreen) {
        this.fontColorGreen = fontColorGreen;
    }

    @Generated
    public int getFontColorBlue() {
        return this.fontColorBlue;
    }

    @Generated
    public void setFontColorBlue(int fontColorBlue) {
        this.fontColorBlue = fontColorBlue;
    }

    @Generated
    public int getBackGroundColorRed() {
        return this.backGroundColorRed;
    }

    @Generated
    public void setBackGroundColorRed(int backGroundColorRed) {
        this.backGroundColorRed = backGroundColorRed;
    }

    @Generated
    public int getBackGroundColorGreen() {
        return this.backGroundColorGreen;
    }

    @Generated
    public void setBackGroundColorGreen(int backGroundColorGreen) {
        this.backGroundColorGreen = backGroundColorGreen;
    }

    @Generated
    public int getBackGroundColorBlue() {
        return this.backGroundColorBlue;
    }

    @Generated
    public void setBackGroundColorBlue(int backGroundColorBlue) {
        this.backGroundColorBlue = backGroundColorBlue;
    }

    @Generated
    public int getBorderColorRed() {
        return this.borderColorRed;
    }

    @Generated
    public void setBorderColorRed(int borderColorRed) {
        this.borderColorRed = borderColorRed;
    }

    @Generated
    public int getBorderColorGreen() {
        return this.borderColorGreen;
    }

    @Generated
    public void setBorderColorGreen(int borderColorGreen) {
        this.borderColorGreen = borderColorGreen;
    }

    @Generated
    public int getBorderColorBlue() {
        return this.borderColorBlue;
    }

    @Generated
    public void setBorderColorBlue(int borderColorBlue) {
        this.borderColorBlue = borderColorBlue;
    }

    @Generated
    public int getMinimumWidth() {
        return this.minimumWidth;
    }

    @Generated
    public void setMinimumWidth(int minimumWidth) {
        this.minimumWidth = minimumWidth;
    }

    @Generated
    public int getMinimumHeight() {
        return this.minimumHeight;
    }

    @Generated
    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }
}

