/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.logging;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import org.apache.hop.core.Const;
import org.apache.hop.core.logging.HopLoggingEvent;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.logging.LogMessage;

public class FixedWidthLogLayout {
    private static final ThreadLocal<SimpleDateFormat> LOCAL_SIMPLE_DATE_PARSER = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"));
    private static final int MAX_LOG_LEVEL_LENGTH = Arrays.stream(LogLevel.getLogLevelCodes()).map(String::length).reduce(0, Integer::max);
    private boolean timeAdded;

    public FixedWidthLogLayout() {
        this(true);
    }

    public FixedWidthLogLayout(boolean addTime) {
        this.timeAdded = addTime;
    }

    public String format(HopLoggingEvent event) {
        Object object;
        StringBuilder line = new StringBuilder();
        Object dateTimeString = "";
        if (this.timeAdded) {
            dateTimeString = LOCAL_SIMPLE_DATE_PARSER.get().format(new Date(event.timeStamp)) + " ";
        }
        if ((object = event.getMessage()) instanceof LogMessage) {
            LogMessage message = (LogMessage)object;
            String logLevel = this.getLogLevelPadded(message.getLevel());
            String[] parts = message.getMessage() == null ? new String[]{} : message.getMessage().split(Const.CR);
            for (int i = 0; i < parts.length; ++i) {
                if (!message.isSimplified()) {
                    line.append((String)dateTimeString);
                    line.append(logLevel);
                    if (message.getSubject() != null) {
                        line.append(message.getSubject());
                        if (message.getCopy() != null) {
                            line.append(".").append(message.getCopy());
                        }
                        line.append(" - ");
                    }
                }
                line.append(parts[i]);
                if (i >= parts.length - 1) continue;
                line.append(Const.CR);
            }
        } else {
            line.append((String)dateTimeString);
            line.append(object != null ? object.toString() : "<null>");
        }
        return line.toString();
    }

    private String getLogLevelPadded(LogLevel logLevel) {
        String code = logLevel.getCode();
        return "[" + code + "] " + " ".repeat(Math.max(MAX_LOG_LEVEL_LENGTH - code.length(), 0));
    }
}

