/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.normaliser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.normaliser.NormaliserData;
import org.apache.hop.pipeline.transforms.normaliser.NormaliserField;
import org.apache.hop.pipeline.transforms.normaliser.NormaliserMeta;

public class Normaliser
extends BaseTransform<NormaliserMeta, NormaliserData> {
    private static final Class<?> PKG = NormaliserMeta.class;

    public Normaliser(TransformMeta transformMeta, NormaliserMeta meta, NormaliserData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        List<Integer> normFieldList;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((NormaliserData)this.data).inputRowMeta = this.getInputRowMeta();
            ((NormaliserData)this.data).outputRowMeta = ((NormaliserData)this.data).inputRowMeta.clone();
            ((NormaliserMeta)this.meta).getFields(((NormaliserData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((NormaliserData)this.data).typeToFieldIndex = new HashMap<String, List<Integer>>();
            ((NormaliserData)this.data).type_occ = new ArrayList<String>();
            ((NormaliserData)this.data).maxlen = 0;
            for (NormaliserField field : ((NormaliserMeta)this.meta).getNormaliserFields()) {
                int dataFieldNr;
                String typeValue = field.getValue();
                if (!((NormaliserData)this.data).type_occ.contains(typeValue)) {
                    ((NormaliserData)this.data).type_occ.add(typeValue);
                }
                if (typeValue.length() > ((NormaliserData)this.data).maxlen) {
                    ((NormaliserData)this.data).maxlen = typeValue.length();
                }
                if ((dataFieldNr = ((NormaliserData)this.data).inputRowMeta.indexOfValue(field.getName())) < 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"Normaliser.Log.CouldNotFindFieldInRow", (String[])new String[]{field.getName()}));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                normFieldList = ((NormaliserData)this.data).typeToFieldIndex.get(typeValue);
                if (normFieldList == null) {
                    normFieldList = new ArrayList<Integer>();
                    ((NormaliserData)this.data).typeToFieldIndex.put(typeValue, normFieldList);
                }
                normFieldList.add(dataFieldNr);
            }
            ((NormaliserData)this.data).copyFieldnrs = new ArrayList<Integer>();
            Set<String> normaliserFields = ((NormaliserMeta)this.meta).getFieldNames();
            int irmSize = ((NormaliserData)this.data).inputRowMeta.size();
            for (int i = 0; i < irmSize; ++i) {
                IValueMeta v = ((NormaliserData)this.data).inputRowMeta.getValueMeta(i);
                if (normaliserFields.contains(v.getName().toLowerCase())) continue;
                ((NormaliserData)this.data).copyFieldnrs.add(i);
            }
        }
        int typeOccSize = ((NormaliserData)this.data).type_occ.size();
        int copyFldNrsSz = ((NormaliserData)this.data).copyFieldnrs.size();
        int rowMetaSz = ((NormaliserData)this.data).outputRowMeta.size();
        for (int e = 0; e < typeOccSize; ++e) {
            String typeValue = ((NormaliserData)this.data).type_occ.get(e);
            Object[] outputRowData = new Object[rowMetaSz];
            int outputIndex = 0;
            for (int i = 0; i < copyFldNrsSz; ++i) {
                int nr = ((NormaliserData)this.data).copyFieldnrs.get(i);
                outputRowData[outputIndex++] = r[nr];
            }
            outputRowData[outputIndex++] = typeValue;
            normFieldList = ((NormaliserData)this.data).typeToFieldIndex.get(typeValue);
            int normFieldListSz = normFieldList.size();
            for (Integer integer : normFieldList) {
                Object value = r[integer];
                outputRowData[outputIndex++] = value;
            }
            this.putRow(((NormaliserData)this.data).outputRowMeta, outputRowData);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Normaliser.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }
}

