/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.ResourceBundleLoader;
import com.ibm.as400.access.Trace;
import java.math.BigDecimal;
import java.math.BigInteger;

public class AS400ZonedDecimal
implements AS400DataType {
    static final long serialVersionUID = 4L;
    private int digits;
    private int scale;
    private static final long defaultValue = 0L;
    private static final boolean HIGH_NIBBLE = true;
    private static final boolean LOW_NIBBLE = false;
    private boolean useDouble_ = false;

    public AS400ZonedDecimal(int numDigits, int numDecimalPositions) {
        if (numDigits < 1 || numDigits > 63) {
            throw new ExtendedIllegalArgumentException("numDigits (" + String.valueOf(numDigits) + ")", 4);
        }
        if (numDecimalPositions < 0 || numDecimalPositions > numDigits) {
            throw new ExtendedIllegalArgumentException("numDecimalPositions (" + String.valueOf(numDecimalPositions) + ")", 4);
        }
        this.digits = numDigits;
        this.scale = numDecimalPositions;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            Trace.log(2, "Unexpected cloning error", (Throwable)e);
            throw new InternalErrorException(6, (Throwable)e);
        }
    }

    @Override
    public int getByteLength() {
        return this.digits;
    }

    @Override
    public Object getDefaultValue() {
        return BigDecimal.valueOf(0L);
    }

    @Override
    public int getInstanceType() {
        return 12;
    }

    @Override
    public Class getJavaType() {
        return BigDecimal.class;
    }

    public int getNumberOfDigits() {
        return this.digits;
    }

    public int getNumberOfDecimalPositions() {
        return this.scale;
    }

    public boolean isUseDouble() {
        return this.useDouble_;
    }

    public void setUseDouble(boolean b) {
        this.useDouble_ = b;
    }

    @Override
    public byte[] toBytes(Object javaValue) {
        byte[] as400Value = new byte[this.digits];
        this.toBytes(javaValue, as400Value, 0);
        return as400Value;
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value) {
        return this.toBytes(javaValue, as400Value, 0);
    }

    @Override
    public int toBytes(Object javaValue, byte[] as400Value, int offset) {
        int outDigits = this.digits;
        int outDecimalPlaces = this.scale;
        BigDecimal inValue = (BigDecimal)javaValue;
        if (inValue.scale() > outDecimalPlaces) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 1);
        }
        int sign = inValue.signum();
        char[] inChars = inValue.abs().movePointRight(outDecimalPlaces).toBigInteger().toString().toCharArray();
        int inLength = inChars.length;
        if (inLength > outDigits) {
            throw new ExtendedIllegalArgumentException("javaValue (" + javaValue.toString() + ")", 1);
        }
        int inPosition = 0;
        for (int i = 0; i < outDigits - inLength; ++i) {
            as400Value[offset++] = -16;
        }
        while (inPosition < inChars.length - 1) {
            as400Value[offset++] = (byte)(inChars[inPosition++] & 0xF | 0xF0);
        }
        as400Value[offset] = sign != -1 ? (byte)(inChars[inPosition] & 0xF | 0xF0) : (byte)(inChars[inPosition] & 0xF | 0xD0);
        return outDigits;
    }

    public byte[] toBytes(double doubleValue) {
        byte[] as400Value = new byte[this.digits];
        this.toBytes(doubleValue, as400Value, 0);
        return as400Value;
    }

    public int toBytes(double doubleValue, byte[] as400Value) {
        return this.toBytes(doubleValue, as400Value, 0);
    }

    public int toBytes(double doubleValue, byte[] as400Value, int offset) {
        int nextDigit;
        int i;
        double absValue = Math.abs(doubleValue);
        if (absValue > 9.223372036854776E18) {
            throw new ExtendedIllegalArgumentException("doubleValue", 1);
        }
        long leftSide = (long)absValue;
        int effectiveScale = this.scale > 15 ? 15 : this.scale;
        long rightSide = Math.round((absValue - (double)leftSide) * Math.pow(10.0, effectiveScale));
        int rightmostOffset = offset + this.digits - 1;
        int padOffset = rightmostOffset - (this.scale - effectiveScale);
        for (int i2 = rightmostOffset; i2 > padOffset; --i2) {
            as400Value[i2] = -16;
        }
        int decimalOffset = rightmostOffset - this.scale;
        for (i = padOffset; i > decimalOffset; --i) {
            nextDigit = (int)(rightSide % 10L);
            as400Value[i] = (byte)(0xF0 | nextDigit);
            rightSide /= 10L;
        }
        for (i = decimalOffset; i >= offset; --i) {
            nextDigit = (int)(leftSide % 10L);
            as400Value[i] = (byte)(0xF0 | nextDigit);
            leftSide /= 10L;
        }
        if (doubleValue < 0.0) {
            as400Value[rightmostOffset] = (byte)(as400Value[rightmostOffset] & 0xDF);
        }
        if (leftSide > 0L) {
            throw new ExtendedIllegalArgumentException("doubleValue", 1);
        }
        return this.digits;
    }

    public double toDouble(byte[] as400Value) {
        return this.toDouble(as400Value, 0);
    }

    public double toDouble(byte[] as400Value, int offset) {
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(offset));
        }
        int rightMostOffset = offset + this.digits - 1;
        double doubleValue = 0.0;
        if (this.digits < 19) {
            long longValue = 0L;
            double divisor = Math.pow(10.0, this.scale);
            for (int i = offset; i <= rightMostOffset; ++i) {
                longValue = longValue * 10L + (long)((byte)(as400Value[i] & 0xF));
            }
            doubleValue = (double)longValue / divisor;
        } else {
            double divisor = Math.pow(10.0, this.scale);
            for (int i = offset; i <= rightMostOffset; ++i) {
                doubleValue = doubleValue * 10.0 + (double)((byte)(as400Value[i] & 0xF));
            }
            doubleValue /= divisor;
        }
        switch (as400Value[rightMostOffset] & 0xF0) {
            case 176: 
            case 208: {
                doubleValue *= -1.0;
                break;
            }
            case 160: 
            case 192: 
            case 224: 
            case 240: {
                break;
            }
            default: {
                AS400ZonedDecimal.throwNumberFormatException(true, rightMostOffset, as400Value[rightMostOffset] & 0xFF, as400Value);
            }
        }
        return doubleValue;
    }

    @Override
    public Object toObject(byte[] as400Value) {
        return this.toObject(as400Value, 0);
    }

    @Override
    public Object toObject(byte[] as400Value, int offset) {
        if (this.useDouble_) {
            return this.toDouble(as400Value, offset);
        }
        if (offset < 0) {
            throw new ArrayIndexOutOfBoundsException(String.valueOf(offset));
        }
        int size = this.digits;
        int outputPosition = 0;
        boolean digitsPlaced = false;
        char[] outputData = null;
        int nibble = (as400Value[offset + size - 1] & 0xFF) >>> 4;
        switch (nibble) {
            case 11: 
            case 13: {
                outputData = new char[size + 1];
                outputData[outputPosition++] = 45;
                break;
            }
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                outputData = new char[size];
                break;
            }
            default: {
                AS400ZonedDecimal.throwNumberFormatException(true, offset + size - 1, as400Value[offset + size - 1] & 0xFF, as400Value);
                return null;
            }
        }
        while (outputPosition < outputData.length) {
            if ((nibble = as400Value[offset++] & 0xF) > 9) {
                if (Trace.traceOn_) {
                    Trace.log(2, " outputPosition=" + outputPosition + " outputData.length=" + outputData.length + " offset (after increment)= " + offset);
                }
                AS400ZonedDecimal.throwNumberFormatException(false, offset - 1, as400Value[offset - 1] & 0xFF, as400Value);
            }
            outputData[outputPosition++] = (char)(nibble | 0x30);
        }
        return new BigDecimal(new BigInteger(new String(outputData)), this.scale);
    }

    static final void throwNumberFormatException(boolean highNibble, int byteOffset, int byteValue, byte[] fieldBytes) throws NumberFormatException {
        String text = highNibble ? ResourceBundleLoader.getText("EXC_HIGH_NIBBLE_NOT_VALID", Integer.toString(byteOffset), AS400ZonedDecimal.byteToString(byteValue)) : ResourceBundleLoader.getText("EXC_LOW_NIBBLE_NOT_VALID", Integer.toString(byteOffset), AS400ZonedDecimal.byteToString(byteValue));
        if (Trace.traceOn_) {
            Trace.log(2, "Byte sequence is not valid for a field of type 'zoned decimal':", fieldBytes);
        }
        NumberFormatException nfe = new NumberFormatException(text);
        if (Trace.traceOn_) {
            Trace.log(2, nfe);
        }
        throw nfe;
    }

    private static final String byteToString(int byteVal) {
        int leftDigitValue = byteVal >>> 4 & 0xF;
        int rightDigitValue = byteVal & 0xF;
        char[] digitChars = new char[]{leftDigitValue < 10 ? (char)(48 + leftDigitValue) : (char)(leftDigitValue - 10 + 65), rightDigitValue < 10 ? (char)(48 + rightDigitValue) : (char)(rightDigitValue - 10 + 65)};
        return new String(digitChars);
    }
}

