/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400BidiTransform;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.BidiConversionProperties;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ConverterImpl;
import com.ibm.as400.access.Trace;
import java.io.CharConversionException;
import java.io.UnsupportedEncodingException;

public class ConverterImplRemote
implements ConverterImpl {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    public ConvTable table_;

    public ConverterImplRemote() {
    }

    public ConverterImplRemote(ConvTable table) {
        this.table_ = table;
    }

    String byteArrayToString(byte[] source) {
        return this.byteArrayToString(source, 0, source.length, new BidiConversionProperties());
    }

    String byteArrayToString(byte[] source, int offset) {
        return this.byteArrayToString(source, offset, source.length - offset, new BidiConversionProperties());
    }

    @Override
    public String byteArrayToString(byte[] source, int offset, int length) {
        return this.byteArrayToString(source, offset, length, new BidiConversionProperties());
    }

    public String byteArrayToString(byte[] source, int offset, int length, int type) {
        return this.byteArrayToString(source, offset, length, new BidiConversionProperties(type));
    }

    @Override
    public String byteArrayToString(byte[] source, int offset, int length, BidiConversionProperties properties) {
        return this.table_.byteArrayToString(source, offset, length, properties);
    }

    static ConverterImplRemote getConverter(int ccsid, AS400ImplRemote system) throws UnsupportedEncodingException {
        return new ConverterImplRemote(ConvTable.getTable(ccsid, system));
    }

    @Override
    public String getEncoding() {
        return this.table_.getEncoding();
    }

    @Override
    public int getCcsid() {
        return this.table_.getCcsid();
    }

    int getStringType(int ccsid) {
        if (AS400BidiTransform.isBidiCcsid(ccsid)) {
            return AS400BidiTransform.getStringType(ccsid);
        }
        return 0;
    }

    @Override
    public void setCcsid(int ccsid, AS400Impl system) throws UnsupportedEncodingException {
        this.table_ = ConvTable.getTable(ccsid, null);
    }

    @Override
    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        this.table_ = ConvTable.getTable(encoding);
    }

    @Override
    public byte[] stringToByteArray(String source) {
        return this.stringToByteArray(source, new BidiConversionProperties());
    }

    public byte[] stringToByteArray(String source, int type) {
        return this.stringToByteArray(source, new BidiConversionProperties(type));
    }

    @Override
    public byte[] stringToByteArray(String source, BidiConversionProperties properties) {
        return this.table_.stringToByteArray(source, properties);
    }

    void stringToByteArray(String source, byte[] destination) throws CharConversionException {
        byte[] convertedBytes = this.stringToByteArray(source, new BidiConversionProperties());
        if (convertedBytes.length > destination.length) {
            System.arraycopy(convertedBytes, 0, destination, 0, destination.length);
            if (Trace.traceOn_) {
                Trace.log(5, "Destination not large enough during conversion: " + source.length() + "," + destination.length);
            }
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, 0, convertedBytes.length);
    }

    void stringToByteArray(String source, byte[] destination, int offset) throws CharConversionException {
        byte[] convertedBytes = this.stringToByteArray(source, new BidiConversionProperties());
        if (convertedBytes.length > destination.length - offset) {
            System.arraycopy(convertedBytes, 0, destination, offset, destination.length - offset);
            if (Trace.traceOn_) {
                Trace.log(5, "Destination not large enough during conversion: " + source.length() + "," + destination.length + "," + offset);
            }
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, offset, convertedBytes.length);
    }

    void stringToByteArray(String source, byte[] destination, int offset, int length) throws CharConversionException {
        this.stringToByteArray(source, destination, offset, length, new BidiConversionProperties());
    }

    void stringToByteArray(String source, byte[] destination, int offset, int length, int type) throws CharConversionException {
        this.stringToByteArray(source, destination, offset, length, new BidiConversionProperties(type));
    }

    void stringToByteArray(String source, byte[] destination, int offset, int length, BidiConversionProperties properties) throws CharConversionException {
        byte[] convertedBytes = this.stringToByteArray(source, properties);
        if (convertedBytes.length > length) {
            System.arraycopy(convertedBytes, 0, destination, offset, length);
            if (Trace.traceOn_) {
                Trace.log(5, "Destination not large enough during conversion: " + source.length() + "," + destination.length + "," + offset + "," + length);
            }
            throw new CharConversionException();
        }
        System.arraycopy(convertedBytes, 0, destination, offset, convertedBytes.length);
    }

    @Override
    public byte[] charArrayToByteArray(char[] source) {
        return this.charArrayToByteArray(source, new BidiConversionProperties());
    }

    @Override
    public byte[] charArrayToByteArray(char[] source, BidiConversionProperties properties) {
        return this.table_.charArrayToByteArray(source, properties);
    }

    @Override
    public char[] byteArrayToCharArray(byte[] source, int offset, int length) {
        return this.byteArrayToCharArray(source, offset, length, new BidiConversionProperties());
    }

    @Override
    public char[] byteArrayToCharArray(byte[] source, int offset, int length, BidiConversionProperties properties) {
        return this.table_.byteArrayToCharArray(source, offset, length, properties);
    }
}

