/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.options;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@VisibleForTesting
public class DefaultGcpRegionFactory
implements DefaultValueFactory<String> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(DefaultGcpRegionFactory.class);

    public @UnknownKeyFor @NonNull @Initialized String create(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        String environmentRegion = DefaultGcpRegionFactory.getRegionFromEnvironment();
        if (!Strings.isNullOrEmpty((String)environmentRegion)) {
            LOG.info("Using default GCP region {} from $CLOUDSDK_COMPUTE_REGION", (Object)environmentRegion);
            return environmentRegion;
        }
        try {
            String gcloudRegion = DefaultGcpRegionFactory.getRegionFromGcloudCli(2000L);
            if (!gcloudRegion.isEmpty()) {
                LOG.info("Using default GCP region {} from gcloud CLI", (Object)gcloudRegion);
                return gcloudRegion;
            }
        }
        catch (Exception e) {
            LOG.debug("Unable to get gcloud compute region", (Throwable)e);
        }
        return "";
    }

    @VisibleForTesting
    public static @UnknownKeyFor @NonNull @Initialized String getRegionFromEnvironment() {
        return System.getenv("CLOUDSDK_COMPUTE_REGION");
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized String getRegionFromGcloudCli(@UnknownKeyFor @NonNull @Initialized long waitMs) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized InterruptedException, @UnknownKeyFor @NonNull @Initialized TimeoutException {
        Process process = DefaultGcpRegionFactory.startGcloud();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
             BufferedReader errorReader = new BufferedReader(new InputStreamReader(process.getErrorStream(), StandardCharsets.UTF_8));){
            if (process.waitFor(waitMs, TimeUnit.MILLISECONDS) && process.exitValue() == 0) {
                String string = reader.lines().collect(Collectors.joining());
                return string;
            }
            if (process.isAlive()) {
                throw new TimeoutException("gcloud subprocess is still running. Giving up.");
            }
            String stderr = errorReader.lines().collect(Collectors.joining("\n"));
            throw new RuntimeException(String.format("gcloud exited with exit value %d. Stderr:%n%s", process.exitValue(), stderr));
        }
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Process startGcloud() throws @UnknownKeyFor @NonNull @Initialized IOException {
        ProcessBuilder pb = new ProcessBuilder(Arrays.asList("gcloud", "config", "get-value", "compute/region"));
        return pb.start();
    }
}

