/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.clusterframework;

import org.apache.flink.api.common.resources.CPUResource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.util.Preconditions;

public class TaskExecutorProcessSpecBuilder {
    private final Configuration configuration;

    private TaskExecutorProcessSpecBuilder(Configuration configuration) {
        this.configuration = new Configuration((Configuration)Preconditions.checkNotNull((Object)configuration));
    }

    static TaskExecutorProcessSpecBuilder newBuilder(Configuration configuration) {
        return new TaskExecutorProcessSpecBuilder(configuration);
    }

    public TaskExecutorProcessSpecBuilder withCpuCores(double cpuCores) {
        return this.withCpuCores(new CPUResource(cpuCores));
    }

    public TaskExecutorProcessSpecBuilder withCpuCores(CPUResource cpuCores) {
        this.configuration.set(TaskManagerOptions.CPU_CORES, (Object)cpuCores.getValue().doubleValue());
        return this;
    }

    public TaskExecutorProcessSpecBuilder withTotalProcessMemory(MemorySize totalProcessMemory) {
        this.configuration.set(TaskManagerOptions.TOTAL_PROCESS_MEMORY, (Object)totalProcessMemory);
        return this;
    }

    public TaskExecutorProcessSpec build() {
        return TaskExecutorProcessUtils.processSpecFromConfig(this.configuration);
    }
}

