/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sasinput;

import com.epam.parso.Column;
import com.epam.parso.ColumnFormat;
import com.epam.parso.impl.SasFileReaderImpl;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sasinput.SasInput;
import org.apache.hop.pipeline.transforms.sasinput.SasInputData;
import org.apache.hop.pipeline.transforms.sasinput.SasInputField;
import org.apache.hop.pipeline.transforms.sasinput.SasUtil;

@Transform(id="SASInput", image="sasinput.svg", name="i18n::SasInput.Transform.Name", description="i18n::SasInput.Transform.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", keywords={"i18n::SasInputMeta.keyword"}, documentationUrl="/pipeline/transforms/sasinput.html")
public class SasInputMeta
extends BaseTransformMeta<SasInput, SasInputData> {
    private static final Class<?> PKG = SasInputMeta.class;
    @HopMetadataProperty(key="accept_field")
    private String acceptingField;
    @HopMetadataProperty(key="field")
    private List<SasInputField> outputFields = new ArrayList<SasInputField>();
    @HopMetadataProperty(key="meta_filename")
    private String metadataFilename;
    @HopMetadataProperty
    private String limit;

    public SasInputMeta() {
    }

    public SasInputMeta(SasInputMeta m) {
        this();
        this.acceptingField = m.acceptingField;
        this.metadataFilename = m.metadataFilename;
        this.limit = m.limit;
        for (SasInputField field : m.outputFields) {
            this.outputFields.add(new SasInputField(field));
        }
    }

    public SasInputMeta clone() {
        return new SasInputMeta(this);
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String metaFilename = variables.resolve(this.metadataFilename);
        if (StringUtils.isEmpty((String)metaFilename)) {
            for (SasInputField field : this.outputFields) {
                try {
                    IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)field.getRename(), (int)field.getType());
                    valueMeta.setLength(field.getLength(), field.getPrecision());
                    valueMeta.setDecimalSymbol(field.getDecimalSymbol());
                    valueMeta.setGroupingSymbol(field.getGroupingSymbol());
                    valueMeta.setConversionMask(field.getConversionMask());
                    valueMeta.setTrimType(field.getTrimType());
                    valueMeta.setOrigin(name);
                    inputRowMeta.addValueMeta(valueMeta);
                }
                catch (Exception e) {
                    throw new HopTransformException((Throwable)e);
                }
            }
        } else {
            try (InputStream inputStream = HopVfs.getInputStream((String)metaFilename, (IVariables)variables);){
                SasFileReaderImpl sasFileReader = new SasFileReaderImpl(inputStream);
                List columns = sasFileReader.getColumns();
                for (Column column : columns) {
                    ColumnFormat format = column.getFormat();
                    String columnName = column.getName();
                    int length = format.getWidth() == 0 ? -1 : format.getWidth();
                    int precision = format.getPrecision() == 0 ? -1 : format.getWidth();
                    int columnType = SasUtil.getHopDataType(column.getType());
                    IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)columnName, (int)columnType, (int)length, (int)precision);
                    valueMeta.setOrigin(name);
                    inputRowMeta.addValueMeta(valueMeta);
                }
            }
            catch (Exception e) {
                throw new HopTransformException("Error reading from metadata file: " + metaFilename);
            }
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (Utils.isEmpty((CharSequence)this.getAcceptingField())) {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SASInput.Log.Error.InvalidAcceptingFieldName", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    @Generated
    public String getAcceptingField() {
        return this.acceptingField;
    }

    @Generated
    public List<SasInputField> getOutputFields() {
        return this.outputFields;
    }

    @Generated
    public String getMetadataFilename() {
        return this.metadataFilename;
    }

    @Generated
    public String getLimit() {
        return this.limit;
    }

    @Generated
    public void setAcceptingField(String acceptingField) {
        this.acceptingField = acceptingField;
    }

    @Generated
    public void setOutputFields(List<SasInputField> outputFields) {
        this.outputFields = outputFields;
    }

    @Generated
    public void setMetadataFilename(String metadataFilename) {
        this.metadataFilename = metadataFilename;
    }

    @Generated
    public void setLimit(String limit) {
        this.limit = limit;
    }
}

