/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.options.AutoValue_ProxyInvocationHandler_BoundValue;
import org.apache.beam.sdk.options.AutoValue_ProxyInvocationHandler_DisplayDataValue;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptionSpec;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsReflector;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Defaults;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableClassToInstanceMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@ThreadSafe
class ProxyInvocationHandler
implements InvocationHandler,
Serializable {
    private final @UnknownKeyFor @NonNull @Initialized int hashCode = ThreadLocalRandom.current().nextInt();
    private final @UnknownKeyFor @NonNull @Initialized AtomicInteger revision;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private volatile @UnknownKeyFor @NonNull @Initialized ComputedProperties computedProperties;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"})
    private final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BoundValue> options;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonNode> jsonOptions;

    ProxyInvocationHandler(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> options) {
        this(ProxyInvocationHandler.bindOptions(options), Maps.newHashMap(), 0);
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BoundValue> bindOptions(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object> inputOptions) {
        HashMap options = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : inputOptions.entrySet()) {
            options.put(entry.getKey(), BoundValue.fromExplicitOption(entry.getValue()));
        }
        return options;
    }

    private ProxyInvocationHandler(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BoundValue> options, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonNode> jsonOptions, @UnknownKeyFor @NonNull @Initialized int revision) {
        this.options = new ConcurrentHashMap<String, BoundValue>(options);
        this.jsonOptions = ImmutableMap.copyOf(jsonOptions);
        this.revision = new AtomicInteger(revision);
        this.computedProperties = new ComputedProperties(ImmutableClassToInstanceMap.of(), ImmutableMap.of(), ImmutableMap.of(), ImmutableSet.copyOf(PipelineOptionsFactory.getRegisteredOptions()));
    }

    @Override
    @SuppressFBWarnings(value={"AT_OPERATION_SEQUENCE_ON_CONCURRENT_ABSTRACTION"})
    public @UnknownKeyFor @NonNull @Initialized Object invoke(@UnknownKeyFor @NonNull @Initialized Object proxy, @UnknownKeyFor @NonNull @Initialized Method method, @UnknownKeyFor @NonNull @Initialized Object @UnknownKeyFor @NonNull @Initialized [] args) {
        if (args == null && "toString".equals(method.getName())) {
            return this.toString();
        }
        if (args != null && args.length == 1 && "equals".equals(method.getName())) {
            return this.equals(args[0]);
        }
        if (args == null && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if (args == null && "outputRuntimeOptions".equals(method.getName())) {
            return this.outputRuntimeOptions((PipelineOptions)proxy);
        }
        if (args == null && "revision".equals(method.getName())) {
            return this.revision.get();
        }
        if (args != null && "as".equals(method.getName()) && args[0] instanceof Class) {
            Class clazz = (Class)args[0];
            return this.as(clazz);
        }
        if (args != null && "populateDisplayData".equals(method.getName()) && args[0] instanceof DisplayData.Builder) {
            DisplayData.Builder builder = (DisplayData.Builder)args[0];
            builder.delegate(new PipelineOptionsDisplayData());
            return Void.TYPE;
        }
        String methodName = method.getName();
        ComputedProperties properties = this.computedProperties;
        if (properties.gettersToPropertyNames.containsKey((Object)methodName)) {
            String propertyName = (String)properties.gettersToPropertyNames.get((Object)methodName);
            if (!this.options.containsKey(propertyName)) {
                Object value = this.jsonOptions.containsKey((Object)propertyName) ? this.getValueFromJson(propertyName, method) : this.getDefault((PipelineOptions)proxy, method);
                this.options.put(propertyName, BoundValue.fromDefault(value));
            }
            return this.options.get(propertyName).getValue();
        }
        if (properties.settersToPropertyNames.containsKey((Object)methodName)) {
            BoundValue prev = this.options.put((String)properties.settersToPropertyNames.get((Object)methodName), BoundValue.fromExplicitOption(args[0]));
            if (prev == null ? args[0] != null : !Objects.equals(args[0], prev.getValue())) {
                this.revision.incrementAndGet();
            }
            return Void.TYPE;
        }
        throw new RuntimeException("Unknown method [" + method + "] invoked with args [" + Arrays.toString(args) + "].");
    }

    public @UnknownKeyFor @NonNull @Initialized String getOptionName(@UnknownKeyFor @NonNull @Initialized Method method) {
        return (String)this.computedProperties.gettersToPropertyNames.get((Object)method.getName());
    }

    private void writeObject(@UnknownKeyFor @NonNull @Initialized ObjectOutputStream stream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        throw new NotSerializableException("PipelineOptions objects are not serializable and should not be embedded into transforms (did you capture a PipelineOptions object in a field or in an anonymous class?). Instead, if you're using a DoFn, access PipelineOptions at runtime via ProcessContext/StartBundleContext/FinishBundleContext.getPipelineOptions(), or pre-extract necessary fields from PipelineOptions at pipeline construction time.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends PipelineOptions> T as(@UnknownKeyFor @NonNull @Initialized Class<T> iface) {
        Preconditions.checkNotNull(iface);
        Preconditions.checkArgument((boolean)iface.isInterface(), (String)"Not an interface: %s", iface);
        PipelineOptions existingOption = (PipelineOptions)this.computedProperties.interfaceToProxyCache.getInstance(iface);
        if (existingOption == null) {
            ProxyInvocationHandler proxyInvocationHandler = this;
            synchronized (proxyInvocationHandler) {
                existingOption = (PipelineOptions)this.computedProperties.interfaceToProxyCache.getInstance(iface);
                if (existingOption == null) {
                    PipelineOptionsFactory.Registration<T> registration = PipelineOptionsFactory.CACHE.get().validateWellFormed(iface, (Set<Class<? extends PipelineOptions>>)this.computedProperties.knownInterfaces);
                    List<PropertyDescriptor> propertyDescriptors = registration.getPropertyDescriptors();
                    Class<T> proxyClass = registration.getProxyClass();
                    existingOption = (PipelineOptions)InstanceBuilder.ofType(proxyClass).fromClass(proxyClass).withArg(InvocationHandler.class, this).build();
                    this.computedProperties = this.computedProperties.updated(iface, existingOption, propertyDescriptors);
                }
            }
        }
        return (T)existingOption;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object obj) {
        return obj != null && (obj instanceof ProxyInvocationHandler && this == obj || Proxy.isProxyClass(obj.getClass()) && this == Proxy.getInvocationHandler(obj));
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return this.hashCode;
    }

    public @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Object>> outputRuntimeOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
        Set<PipelineOptionSpec> optionSpecs = PipelineOptionsReflector.getOptionSpecs(this.computedProperties.knownInterfaces);
        HashMap properties = Maps.newHashMap();
        for (PipelineOptionSpec spec : optionSpecs) {
            Object vp;
            if (!spec.getGetterMethod().getReturnType().equals(ValueProvider.class) || ((ValueProvider)(vp = this.invoke(options, spec.getGetterMethod(), null))).isAccessible()) continue;
            HashMap property = Maps.newHashMap();
            property.put("type", ((ParameterizedType)spec.getGetterMethod().getGenericReturnType()).getActualTypeArguments()[0]);
            properties.put(spec.getName(), property);
        }
        return properties;
    }

    private @UnknownKeyFor @NonNull @Initialized Multimap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized PipelineOptionSpec> buildOptionNameToSpecMap(@UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized PipelineOptionSpec> props) {
        HashMultimap optionsMap = HashMultimap.create();
        for (PipelineOptionSpec pipelineOptionSpec : props) {
            optionsMap.put((Object)pipelineOptionSpec.getName(), (Object)pipelineOptionSpec);
        }
        for (Map.Entry entry : optionsMap.asMap().entrySet()) {
            ArrayList specs = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            if (specs.size() < 2) continue;
            for (int i = 0; i < specs.size() - 1; ++i) {
                Class<? extends PipelineOptions> iface1 = ((PipelineOptionSpec)specs.get(i)).getDefiningInterface();
                for (int j = i + 1; j < specs.size(); ++j) {
                    Class<? extends PipelineOptions> iface2 = ((PipelineOptionSpec)specs.get(j)).getDefiningInterface();
                    if (iface1.isAssignableFrom(iface2)) {
                        optionsMap.remove(entry.getKey(), specs.get(i));
                        specs.remove(i);
                        --i;
                        j = specs.size();
                        continue;
                    }
                    if (!iface2.isAssignableFrom(iface1)) continue;
                    optionsMap.remove(entry.getKey(), specs.get(j));
                    specs.remove(j);
                    --j;
                }
            }
        }
        return optionsMap;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        TreeMap<String, JsonNode> sortedOptions = new TreeMap<String, JsonNode>((Map<String, JsonNode>)this.jsonOptions);
        for (Map.Entry<String, BoundValue> entry : this.options.entrySet()) {
            sortedOptions.put(entry.getKey(), (JsonNode)entry.getValue().getValue());
        }
        StringBuilder b = new StringBuilder();
        b.append("Current Settings:\n");
        for (Map.Entry entry : sortedOptions.entrySet()) {
            b.append("  " + (String)entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return b.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized Object getValueFromJson(@UnknownKeyFor @NonNull @Initialized String propertyName, @UnknownKeyFor @NonNull @Initialized Method method) {
        JsonNode jsonNode = (JsonNode)this.jsonOptions.get((Object)propertyName);
        return ProxyInvocationHandler.getValueFromJson(jsonNode, method);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object getValueFromJson(@UnknownKeyFor @NonNull @Initialized JsonNode node, @UnknownKeyFor @NonNull @Initialized Method method) {
        try {
            return PipelineOptionsFactory.deserializeNode(node, method);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse representation", e);
        }
    }

    private @UnknownKeyFor @NonNull @Initialized Object getDefault(@UnknownKeyFor @NonNull @Initialized PipelineOptions proxy, @UnknownKeyFor @NonNull @Initialized Method method) {
        Annotation annotation;
        if (method.getReturnType().equals(ValueProvider.RuntimeValueProvider.class)) {
            throw new RuntimeException(String.format("Method %s should not have return type RuntimeValueProvider, use ValueProvider instead.", method.getName()));
        }
        if (method.getReturnType().equals(ValueProvider.StaticValueProvider.class)) {
            throw new RuntimeException(String.format("Method %s should not have return type StaticValueProvider, use ValueProvider instead.", method.getName()));
        }
        @Nullable Object defaultObject = null;
        Annotation[] annotationArray = method.getAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n && (defaultObject = this.returnDefaultHelper(annotation = annotationArray[i], proxy, method)) == null; ++i) {
        }
        if (method.getReturnType().equals(ValueProvider.class)) {
            String propertyName = (String)this.computedProperties.gettersToPropertyNames.get((Object)method.getName());
            return defaultObject == null ? new ValueProvider.RuntimeValueProvider(method.getName(), propertyName, method.getDeclaringClass(), proxy.getOptionsId()) : new ValueProvider.RuntimeValueProvider<Object>(method.getName(), propertyName, method.getDeclaringClass(), defaultObject, proxy.getOptionsId());
        }
        if (defaultObject != null) {
            return defaultObject;
        }
        return Defaults.defaultValue(method.getReturnType());
    }

    private @Nullable @UnknownKeyFor @Initialized Object returnDefaultHelper(@UnknownKeyFor @NonNull @Initialized Annotation annotation, @UnknownKeyFor @NonNull @Initialized PipelineOptions proxy, @UnknownKeyFor @NonNull @Initialized Method method) {
        if (annotation instanceof Default.Class) {
            return ((Default.Class)annotation).value();
        }
        if (annotation instanceof Default.String) {
            return ((Default.String)annotation).value();
        }
        if (annotation instanceof Default.Boolean) {
            return ((Default.Boolean)annotation).value();
        }
        if (annotation instanceof Default.Character) {
            return Character.valueOf(((Default.Character)annotation).value());
        }
        if (annotation instanceof Default.Byte) {
            return ((Default.Byte)annotation).value();
        }
        if (annotation instanceof Default.Short) {
            return ((Default.Short)annotation).value();
        }
        if (annotation instanceof Default.Integer) {
            return ((Default.Integer)annotation).value();
        }
        if (annotation instanceof Default.Long) {
            return ((Default.Long)annotation).value();
        }
        if (annotation instanceof Default.Float) {
            return Float.valueOf(((Default.Float)annotation).value());
        }
        if (annotation instanceof Default.Double) {
            return ((Default.Double)annotation).value();
        }
        if (annotation instanceof Default.Enum) {
            return Enum.valueOf(method.getReturnType(), ((Default.Enum)annotation).value());
        }
        if (annotation instanceof Default.InstanceFactory) {
            return InstanceBuilder.ofType(((Default.InstanceFactory)annotation).value()).build().create(proxy);
        }
        return null;
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> generateGettersToPropertyNames(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> propertyDescriptors) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            if (descriptor.getReadMethod() == null) continue;
            builder.put((Object)descriptor.getReadMethod().getName(), (Object)descriptor.getName());
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> generateSettersToPropertyNames(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> propertyDescriptors) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            if (descriptor.getWriteMethod() == null) continue;
            builder.put((Object)descriptor.getWriteMethod().getName(), (Object)descriptor.getName());
        }
        return builder.build();
    }

    static class Deserializer
    extends JsonDeserializer<PipelineOptions> {
        Deserializer() {
        }

        public @UnknownKeyFor @NonNull @Initialized PipelineOptions deserialize(@UnknownKeyFor @NonNull @Initialized JsonParser jp, @UnknownKeyFor @NonNull @Initialized DeserializationContext ctxt) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ObjectNode objectNode = (ObjectNode)jp.readValueAsTree();
            JsonNode rawOptionsNode = objectNode.get("options");
            HashMap fields = Maps.newHashMap();
            if (rawOptionsNode != null && !rawOptionsNode.isNull()) {
                ObjectNode optionsNode = (ObjectNode)rawOptionsNode;
                Iterator iterator = optionsNode.fields();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry field = (Map.Entry)iterator.next();
                    fields.put((String)field.getKey(), (JsonNode)field.getValue());
                }
            }
            int revision = objectNode.hasNonNull("revision") ? objectNode.get("revision").asInt() : 0;
            PipelineOptions options = new ProxyInvocationHandler(Maps.newHashMap(), fields, revision).as(PipelineOptions.class);
            ValueProvider.RuntimeValueProvider.setRuntimeOptions(options);
            return options;
        }
    }

    static class Serializer
    extends JsonSerializer<PipelineOptions> {
        Serializer() {
        }

        private static void serializeEntry(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized JsonGenerator jgen, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSerializer<@UnknownKeyFor @NonNull @Initialized Object>> customSerializers) throws @UnknownKeyFor @NonNull @Initialized IOException {
            JsonSerializer<Object> customSerializer = customSerializers.get(name);
            if (value == null || customSerializer == null || value instanceof JsonNode) {
                jgen.writeObject(value);
            } else {
                customSerializer.serialize(value, jgen, (SerializerProvider)PipelineOptionsFactory.SERIALIZER_PROVIDER);
            }
        }

        public void serialize(@UnknownKeyFor @NonNull @Initialized PipelineOptions value, @UnknownKeyFor @NonNull @Initialized JsonGenerator jgen, @UnknownKeyFor @NonNull @Initialized SerializerProvider provider) throws @UnknownKeyFor @NonNull @Initialized IOException {
            ProxyInvocationHandler handler = (ProxyInvocationHandler)Proxy.getInvocationHandler(value);
            PipelineOptionsFactory.Cache cache = PipelineOptionsFactory.CACHE.get();
            HashMap filteredOptions = Maps.newHashMap((Map)handler.options);
            ImmutableSet<Class<? extends PipelineOptions>> knownInterfaces = ((ProxyInvocationHandler)handler).computedProperties.knownInterfaces;
            Map<String, JsonSerializer<Object>> propertyToSerializer = Serializer.getSerializerMap(cache, knownInterfaces);
            Serializer.removeIgnoredOptions(cache, knownInterfaces, filteredOptions);
            Serializer.ensureSerializable(cache, knownInterfaces, filteredOptions, propertyToSerializer);
            HashMap serializableOptions = Maps.newHashMap((Map)handler.jsonOptions);
            for (Map.Entry entry : filteredOptions.entrySet()) {
                serializableOptions.put((String)entry.getKey(), ((BoundValue)entry.getValue()).getValue());
            }
            jgen.writeStartObject();
            jgen.writeFieldName("options");
            jgen.writeStartObject();
            for (Map.Entry entry : serializableOptions.entrySet()) {
                jgen.writeFieldName((String)entry.getKey());
                Serializer.serializeEntry((String)entry.getKey(), entry.getValue(), jgen, propertyToSerializer);
            }
            jgen.writeEndObject();
            ArrayList serializedDisplayData = Lists.newArrayList();
            DisplayData displayData = DisplayData.from(value);
            for (DisplayData.Item item : displayData.items()) {
                Map serializedItem = (Map)PipelineOptionsFactory.MAPPER.convertValue((Object)item, Map.class);
                serializedDisplayData.add(serializedItem);
            }
            jgen.writeFieldName("display_data");
            jgen.writeObject((Object)serializedDisplayData);
            jgen.writeNumberField("revision", handler.revision.get());
            jgen.writeEndObject();
        }

        private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSerializer<@UnknownKeyFor @NonNull @Initialized Object>> getSerializerMap(@UnknownKeyFor @NonNull @Initialized PipelineOptionsFactory.Cache cache, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> interfaces) {
            HashMap propertyToSerializer = Maps.newHashMap();
            for (PropertyDescriptor descriptor : cache.getPropertyDescriptors(interfaces)) {
                JsonSerializer<Object> maybeSerializer;
                if (descriptor.getReadMethod() == null || (maybeSerializer = PipelineOptionsFactory.getCustomSerializerForMethod(descriptor.getReadMethod())) == null) continue;
                propertyToSerializer.put(descriptor.getName(), maybeSerializer);
            }
            return propertyToSerializer;
        }

        private static void removeIgnoredOptions(@UnknownKeyFor @NonNull @Initialized PipelineOptionsFactory.Cache cache, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> interfaces, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> options) {
            ImmutableSet jsonIgnoreMethodNames = FluentIterable.from(ReflectHelpers.getClosureOfMethodsOnInterfaces(interfaces)).filter(PipelineOptionsFactory.AnnotationPredicates.JSON_IGNORE.forMethod).transform(Method::getName).toSet();
            for (PropertyDescriptor descriptor : cache.getPropertyDescriptors(interfaces)) {
                if (!jsonIgnoreMethodNames.contains(descriptor.getReadMethod().getName())) continue;
                options.remove(descriptor.getName());
            }
        }

        private static void ensureSerializable(@UnknownKeyFor @NonNull @Initialized PipelineOptionsFactory.Cache cache, @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> interfaces, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BoundValue> options, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized JsonSerializer<@UnknownKeyFor @NonNull @Initialized Object>> propertyToSerializer) throws @UnknownKeyFor @NonNull @Initialized IOException {
            HashMap propertyToReadMethod = Maps.newHashMap();
            for (PropertyDescriptor propertyDescriptor : cache.getPropertyDescriptors(interfaces)) {
                if (propertyDescriptor.getReadMethod() == null) continue;
                propertyToReadMethod.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod());
            }
            for (Map.Entry entry : options.entrySet()) {
                try {
                    Object boundValue = ((BoundValue)entry.getValue()).getValue();
                    if (boundValue == null) continue;
                    TokenBuffer buffer = new TokenBuffer((ObjectCodec)PipelineOptionsFactory.MAPPER, false);
                    Serializer.serializeEntry((String)entry.getKey(), boundValue, (JsonGenerator)buffer, propertyToSerializer);
                    Method method = (Method)propertyToReadMethod.get(entry.getKey());
                    ProxyInvocationHandler.getValueFromJson((JsonNode)buffer.asParser().readValueAsTree(), method);
                }
                catch (Exception e) {
                    throw new IOException(String.format("Failed to serialize and deserialize property '%s' with value '%s'", entry.getKey(), ((BoundValue)entry.getValue()).getValue()), e);
                }
            }
        }
    }

    static interface UnknownPipelineOptions
    extends PipelineOptions {
    }

    @AutoValue
    static abstract class DisplayDataValue {
        DisplayDataValue() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Object getValue();

        abstract @UnknownKeyFor @NonNull @Initialized DisplayData.Type getType();

        static @UnknownKeyFor @NonNull @Initialized DisplayDataValue resolve(@Nullable @UnknownKeyFor @Initialized Object value) {
            DisplayData.Type type = DisplayData.inferType(value);
            if (type == null) {
                value = DisplayDataValue.displayDataString(value);
                type = DisplayData.Type.STRING;
            }
            return new AutoValue_ProxyInvocationHandler_DisplayDataValue(value, type);
        }

        private static @UnknownKeyFor @NonNull @Initialized String displayDataString(@Nullable @UnknownKeyFor @Initialized Object value) {
            if (value == null) {
                return "";
            }
            if (!value.getClass().isArray()) {
                return value.toString();
            }
            if (!value.getClass().getComponentType().isPrimitive()) {
                return Arrays.deepToString((Object[])value);
            }
            String wrapped = Arrays.deepToString(new Object[]{value});
            return wrapped.substring(1, wrapped.length() - 1);
        }
    }

    class PipelineOptionsDisplayData
    implements HasDisplayData {
        PipelineOptionsDisplayData() {
        }

        @Override
        public void populateDisplayData(@UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            HashMap copiedOptions = new HashMap(ProxyInvocationHandler.this.options);
            Set<PipelineOptionSpec> optionSpecs = PipelineOptionsReflector.getOptionSpecs(((ProxyInvocationHandler)ProxyInvocationHandler.this).computedProperties.knownInterfaces);
            Multimap optionsMap = ProxyInvocationHandler.this.buildOptionNameToSpecMap(optionSpecs);
            for (Map.Entry option : copiedOptions.entrySet()) {
                BoundValue boundValue = (BoundValue)option.getValue();
                if (boundValue.isDefault()) continue;
                DisplayDataValue resolved = DisplayDataValue.resolve(boundValue.getValue());
                HashSet specs = new HashSet(optionsMap.get((Object)((String)option.getKey())));
                for (PipelineOptionSpec optionSpec : specs) {
                    if (!optionSpec.shouldSerialize() || optionSpec.getGetterMethod().isAnnotationPresent(Hidden.class)) continue;
                    builder.add(DisplayData.item((String)option.getKey(), resolved.getType(), resolved.getValue()).withNamespace(optionSpec.getDefiningInterface()));
                }
            }
            for (Map.Entry jsonOption : ProxyInvocationHandler.this.jsonOptions.entrySet()) {
                if (copiedOptions.containsKey(jsonOption.getKey())) continue;
                HashSet specs = new HashSet(optionsMap.get((Object)((String)jsonOption.getKey())));
                if (specs.isEmpty()) {
                    builder.add(DisplayData.item((String)jsonOption.getKey(), ((JsonNode)jsonOption.getValue()).toString()).withNamespace(UnknownPipelineOptions.class));
                    continue;
                }
                for (PipelineOptionSpec spec : specs) {
                    if (!spec.shouldSerialize() || spec.getGetterMethod().isAnnotationPresent(Hidden.class)) continue;
                    Object value = ProxyInvocationHandler.this.getValueFromJson((String)jsonOption.getKey(), spec.getGetterMethod());
                    DisplayDataValue resolved = DisplayDataValue.resolve(value);
                    builder.add(DisplayData.item((String)jsonOption.getKey(), resolved.getType(), resolved.getValue()).withNamespace(spec.getDefiningInterface()));
                }
            }
        }
    }

    @AutoValue
    static abstract class BoundValue {
        BoundValue() {
        }

        abstract @Nullable @UnknownKeyFor @Initialized Object getValue();

        abstract @UnknownKeyFor @NonNull @Initialized boolean isDefault();

        private static @UnknownKeyFor @NonNull @Initialized BoundValue of(@Nullable @UnknownKeyFor @Initialized Object value, @UnknownKeyFor @NonNull @Initialized boolean isDefault) {
            return new AutoValue_ProxyInvocationHandler_BoundValue(value, isDefault);
        }

        static @UnknownKeyFor @NonNull @Initialized BoundValue fromExplicitOption(@Nullable @UnknownKeyFor @Initialized Object value) {
            return BoundValue.of(value, false);
        }

        static @UnknownKeyFor @NonNull @Initialized BoundValue fromDefault(@Nullable @UnknownKeyFor @Initialized Object value) {
            return BoundValue.of(value, true);
        }
    }

    private static final class ComputedProperties {
        final @UnknownKeyFor @NonNull @Initialized ImmutableClassToInstanceMap<@UnknownKeyFor @NonNull @Initialized PipelineOptions> interfaceToProxyCache;
        final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> gettersToPropertyNames;
        final @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> settersToPropertyNames;
        final @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> knownInterfaces;

        private ComputedProperties(@UnknownKeyFor @NonNull @Initialized ImmutableClassToInstanceMap<@UnknownKeyFor @NonNull @Initialized PipelineOptions> interfaceToProxyCache, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> gettersToPropertyNames, @UnknownKeyFor @NonNull @Initialized ImmutableMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> settersToPropertyNames, @UnknownKeyFor @NonNull @Initialized ImmutableSet<@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized PipelineOptions>> knownInterfaces) {
            this.interfaceToProxyCache = interfaceToProxyCache;
            this.gettersToPropertyNames = gettersToPropertyNames;
            this.settersToPropertyNames = settersToPropertyNames;
            this.knownInterfaces = knownInterfaces;
        }

        <T extends PipelineOptions> @UnknownKeyFor @NonNull @Initialized ComputedProperties updated(@UnknownKeyFor @NonNull @Initialized Class<T> iface, T instance, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PropertyDescriptor> propertyDescriptors) {
            HashMap allNewGetters = Maps.newHashMap(this.gettersToPropertyNames);
            HashMap allNewSetters = Maps.newHashMap(this.settersToPropertyNames);
            HashSet newKnownInterfaces = Sets.newHashSet(this.knownInterfaces);
            HashMap newInterfaceCache = Maps.newHashMap(this.interfaceToProxyCache);
            allNewGetters.putAll(ProxyInvocationHandler.generateGettersToPropertyNames(propertyDescriptors));
            allNewSetters.putAll(ProxyInvocationHandler.generateSettersToPropertyNames(propertyDescriptors));
            newKnownInterfaces.add(iface);
            newInterfaceCache.put(iface, instance);
            return new ComputedProperties((ImmutableClassToInstanceMap<PipelineOptions>)ImmutableClassToInstanceMap.copyOf((Map)newInterfaceCache), (ImmutableMap<String, String>)ImmutableMap.copyOf((Map)allNewGetters), (ImmutableMap<String, String>)ImmutableMap.copyOf((Map)allNewSetters), (ImmutableSet<Class<? extends PipelineOptions>>)ImmutableSet.copyOf((Collection)newKnownInterfaces));
        }
    }
}

