/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;

public class QNameFn
extends SystemFunction {
    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        try {
            Item item = this.argument[1].evaluateItem(staticContext.makeEarlyEvaluationContext());
            String string = item.getStringValue();
            Item item2 = this.argument[0].evaluateItem(staticContext.makeEarlyEvaluationContext());
            String string2 = item2 == null ? "" : item2.getStringValue();
            NameChecker nameChecker = staticContext.getConfiguration().getNameChecker();
            String[] stringArray = nameChecker.getQNameParts(string);
            return new QNameValue(stringArray[0], string2, stringArray[1], nameChecker);
        }
        catch (QNameException qNameException) {
            DynamicError dynamicError = new DynamicError(qNameException.getMessage(), this);
            dynamicError.setErrorCode("FOCA0002");
            dynamicError.setLocator(this);
            throw dynamicError;
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        String string = atomicValue == null ? null : atomicValue.getStringValue();
        try {
            String string2 = this.argument[1].evaluateItem(xPathContext).getStringValue();
            NameChecker nameChecker = xPathContext.getConfiguration().getNameChecker();
            String[] stringArray = nameChecker.getQNameParts(string2);
            return new QNameValue(stringArray[0], string, stringArray[1], nameChecker);
        }
        catch (QNameException qNameException) {
            this.dynamicError(qNameException.getMessage(), "FOCA0002", xPathContext);
            return null;
        }
    }
}

