/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.utils.ByteBufferUtil;

public final class RequestValidations {
    public static void checkTrue(boolean expression, String message) throws InvalidRequestException {
        if (!expression) {
            throw RequestValidations.invalidRequest(message);
        }
    }

    public static void checkTrue(boolean expression, String messageTemplate, Object messageArg) throws InvalidRequestException {
        if (!expression) {
            throw RequestValidations.invalidRequest(messageTemplate, messageArg);
        }
    }

    public static void checkTrue(boolean expression, String messageTemplate, Object arg1, Object arg2) throws InvalidRequestException {
        if (!expression) {
            throw RequestValidations.invalidRequest(messageTemplate, arg1, arg2);
        }
    }

    public static void checkTrue(boolean expression, String messageTemplate, Object arg1, Object arg2, Object arg3) throws InvalidRequestException {
        if (!expression) {
            throw RequestValidations.invalidRequest(messageTemplate, arg1, arg2, arg3);
        }
    }

    public static <T extends Collection<E>, E> T checkNotEmpty(T collection, String messageTemplate, Object messageArg) throws InvalidRequestException {
        RequestValidations.checkTrue(!collection.isEmpty(), messageTemplate, messageArg);
        return collection;
    }

    public static <T extends Collection<E>, E> T checkNotEmpty(T collection, String messageTemplate, Object arg1, Object arg2) throws InvalidRequestException {
        RequestValidations.checkTrue(!collection.isEmpty(), messageTemplate, arg1, arg2);
        return collection;
    }

    public static void checkContainsNoDuplicates(List<?> list, String message) throws InvalidRequestException {
        if (new HashSet(list).size() != list.size()) {
            throw RequestValidations.invalidRequest(message);
        }
    }

    public static <E> void checkContainsOnly(List<E> list, List<E> expectedElements, String message) throws InvalidRequestException {
        ArrayList<E> copy = new ArrayList<E>(list);
        copy.removeAll(expectedElements);
        if (!copy.isEmpty()) {
            throw RequestValidations.invalidRequest(message);
        }
    }

    public static void checkFalse(boolean expression, String messageTemplate, Object messageArg) throws InvalidRequestException {
        RequestValidations.checkTrue(!expression, messageTemplate, messageArg);
    }

    public static void checkFalse(boolean expression, String messageTemplate, Object arg1, Object arg2) throws InvalidRequestException {
        RequestValidations.checkTrue(!expression, messageTemplate, arg1, arg2);
    }

    public static void checkFalse(boolean expression, String messageTemplate, Object arg1, Object arg2, Object arg3) throws InvalidRequestException {
        RequestValidations.checkTrue(!expression, messageTemplate, arg1, arg2, arg3);
    }

    public static void checkFalse(boolean expression, String message) throws InvalidRequestException {
        RequestValidations.checkTrue(!expression, message);
    }

    public static <T> T checkNotNull(T object, String message) throws InvalidRequestException {
        RequestValidations.checkTrue(object != null, message);
        return object;
    }

    public static <T> T checkNotNull(T object, String messageTemplate, Object messageArg) throws InvalidRequestException {
        RequestValidations.checkTrue(object != null, messageTemplate, messageArg);
        return object;
    }

    public static <T> T checkNotNull(T object, String messageTemplate, Object arg1, Object arg2) throws InvalidRequestException {
        RequestValidations.checkTrue(object != null, messageTemplate, arg1, arg2);
        return object;
    }

    public static void checkBindValueSet(ByteBuffer b, String messageTemplate, Object messageArg) throws InvalidRequestException {
        RequestValidations.checkTrue(b != ByteBufferUtil.UNSET_BYTE_BUFFER, messageTemplate, messageArg);
    }

    public static void checkNull(Object object, String messageTemplate, Object messageArg) throws InvalidRequestException {
        RequestValidations.checkTrue(object == null, messageTemplate, messageArg);
    }

    public static void checkNull(Object object, String message) throws InvalidRequestException {
        RequestValidations.checkTrue(object == null, message);
    }

    public static InvalidRequestException invalidRequest(String message) {
        return new InvalidRequestException(message);
    }

    public static InvalidRequestException invalidRequest(String messageTemplate, Object ... messageArgs) {
        return new InvalidRequestException(String.format(messageTemplate, messageArgs));
    }

    private RequestValidations() {
    }
}

