/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.statements.schema;

import org.apache.cassandra.audit.AuditLogContext;
import org.apache.cassandra.audit.AuditLogEntryType;
import org.apache.cassandra.cql3.CQLStatement;
import org.apache.cassandra.cql3.QualifiedName;
import org.apache.cassandra.cql3.statements.schema.AlterSchemaStatement;
import org.apache.cassandra.schema.KeyspaceMetadata;
import org.apache.cassandra.schema.Keyspaces;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.schema.TriggerMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.Event;

public final class DropTriggerStatement
extends AlterSchemaStatement {
    private final String tableName;
    private final String triggerName;
    private final boolean ifExists;

    public DropTriggerStatement(String keyspaceName, String tableName, String triggerName, boolean ifExists) {
        super(keyspaceName);
        this.tableName = tableName;
        this.triggerName = triggerName;
        this.ifExists = ifExists;
    }

    @Override
    public Keyspaces apply(Keyspaces schema) {
        TriggerMetadata trigger;
        KeyspaceMetadata keyspace = schema.getNullable(this.keyspaceName);
        TableMetadata table = null == keyspace ? null : keyspace.tables.getNullable(this.tableName);
        TriggerMetadata triggerMetadata = trigger = null == table ? null : (TriggerMetadata)table.triggers.get(this.triggerName).orElse(null);
        if (null == trigger) {
            if (this.ifExists) {
                return schema;
            }
            throw DropTriggerStatement.ire("Trigger '%s' on '%s.%s' doesn't exist", this.triggerName, this.keyspaceName, this.tableName);
        }
        TableMetadata newTable = table.withSwapped(table.triggers.without(this.triggerName));
        return schema.withAddedOrUpdated(keyspace.withSwapped(keyspace.tables.withSwapped(newTable)));
    }

    @Override
    Event.SchemaChange schemaChangeEvent(Keyspaces.KeyspacesDiff diff) {
        return new Event.SchemaChange(Event.SchemaChange.Change.UPDATED, Event.SchemaChange.Target.TABLE, this.keyspaceName, this.tableName);
    }

    @Override
    public void authorize(ClientState client) {
        client.ensureIsSuperuser("Only superusers are allowed to perfrom DROP TRIGGER queries");
    }

    @Override
    public AuditLogContext getAuditLogContext() {
        return new AuditLogContext(AuditLogEntryType.DROP_TRIGGER, this.keyspaceName, this.triggerName);
    }

    public String toString() {
        return String.format("%s (%s, %s)", this.getClass().getSimpleName(), this.keyspaceName, this.triggerName);
    }

    public static final class Raw
    extends CQLStatement.Raw {
        private final QualifiedName tableName;
        private final String triggerName;
        private final boolean ifExists;

        public Raw(QualifiedName tableName, String triggerName, boolean ifExists) {
            this.tableName = tableName;
            this.triggerName = triggerName;
            this.ifExists = ifExists;
        }

        @Override
        public DropTriggerStatement prepare(ClientState state) {
            String keyspaceName = this.tableName.hasKeyspace() ? this.tableName.getKeyspace() : state.getKeyspace();
            return new DropTriggerStatement(keyspaceName, this.tableName.getName(), this.triggerName, this.ifExists);
        }
    }
}

