/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.metrics;

import com.google.auth.Credentials;
import com.google.cloud.bigtable.data.v2.stub.metrics.BuiltinMetricsView;
import com.google.cloud.bigtable.data.v2.stub.metrics.MetricsProvider;
import com.google.common.base.MoreObjects;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import java.io.IOException;

public final class CustomOpenTelemetryMetricsProvider
implements MetricsProvider {
    private final OpenTelemetry otel;

    public static CustomOpenTelemetryMetricsProvider create(OpenTelemetry otel) {
        return new CustomOpenTelemetryMetricsProvider(otel);
    }

    private CustomOpenTelemetryMetricsProvider(OpenTelemetry otel) {
        this.otel = otel;
    }

    public OpenTelemetry getOpenTelemetry() {
        return this.otel;
    }

    public static void setupSdkMeterProvider(SdkMeterProviderBuilder builder) throws IOException {
        CustomOpenTelemetryMetricsProvider.setupSdkMeterProvider(builder, null, null);
    }

    public static void setupSdkMeterProvider(SdkMeterProviderBuilder builder, Credentials credentials) throws IOException {
        CustomOpenTelemetryMetricsProvider.setupSdkMeterProvider(builder, credentials, null);
    }

    public static void setupSdkMeterProvider(SdkMeterProviderBuilder builder, String endpoint) throws IOException {
        CustomOpenTelemetryMetricsProvider.setupSdkMeterProvider(builder, null, endpoint);
    }

    public static void setupSdkMeterProvider(SdkMeterProviderBuilder builder, Credentials credentials, String endpoint) throws IOException {
        BuiltinMetricsView.registerBuiltinMetrics(credentials, builder, endpoint);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("openTelemetry", (Object)this.otel).toString();
    }
}

