/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Objects;
import org.apache.beam.runners.core.metrics.BoundedTrieData;
import org.apache.beam.runners.core.metrics.DirtyState;
import org.apache.beam.runners.core.metrics.MetricCell;
import org.apache.beam.sdk.metrics.BoundedTrie;
import org.apache.beam.sdk.metrics.MetricName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;

@SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="Some access on purpose are left unsynchronized")
public class BoundedTrieCell
implements BoundedTrie,
MetricCell<BoundedTrieData> {
    private final @UnknownKeyFor @NonNull @Initialized DirtyState dirty = new DirtyState();
    private @UnknownKeyFor @NonNull @Initialized BoundedTrieData value;
    private final @UnknownKeyFor @NonNull @Initialized MetricName name;

    public BoundedTrieCell(@UnknownKeyFor @NonNull @Initialized MetricName name) {
        this.name = name;
        this.value = new BoundedTrieData();
    }

    public synchronized void update(@UnknownKeyFor @NonNull @Initialized BoundedTrieData other) {
        this.value = this.value.combine(other);
        this.dirty.afterModification();
    }

    @Override
    public synchronized void reset() {
        this.value.clear();
        this.dirty.reset();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized DirtyState getDirty() {
        return this.dirty;
    }

    @Override
    public synchronized @UnknownKeyFor @NonNull @Initialized BoundedTrieData getCumulative() {
        return this.value.getCumulative();
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized BoundedTrieData getAndReset() {
        BoundedTrieData shallowCopy = this.value;
        this.value = new BoundedTrieData();
        return shallowCopy;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
        return this.name;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object object) {
        if (object instanceof BoundedTrieCell) {
            BoundedTrieCell boundedTrieCell = (BoundedTrieCell)object;
            return Objects.equals(this.dirty, boundedTrieCell.dirty) && Objects.equals(this.value, boundedTrieCell.value) && Objects.equals(this.name, boundedTrieCell.name);
        }
        return false;
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.dirty, this.value, this.name);
    }

    @Override
    public synchronized void add(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized String> values) {
        this.value.add(values);
        this.dirty.afterModification();
    }

    @Override
    public synchronized void add(String ... values) {
        this.add(Arrays.asList(values));
    }
}

