/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderProvider;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public final class CoderProviders {
    private CoderProviders() {
    }

    public static @UnknownKeyFor @NonNull @Initialized CoderProvider fromStaticMethods(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> rawType, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coderClazz) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)Coder.class.isAssignableFrom(coderClazz), (String)"%s is not a subtype of %s", (Object)coderClazz.getName(), (Object)Coder.class.getSimpleName());
        return new CoderProviderFromStaticMethods(rawType, coderClazz);
    }

    public static @UnknownKeyFor @NonNull @Initialized CoderProvider forCoder(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
        return new CoderProviderForCoder(type, coder);
    }

    private static class CoderProviderForCoder
    extends CoderProvider {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder;
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type;

        public CoderProviderForCoder(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized TypeDescriptor<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> type, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coder) {
            this.type = type;
            this.coder = coder;
        }

        @Override
        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            boolean isAutoValueConcrete;
            boolean isTypeEqual = this.type.equals(type);
            boolean bl = isAutoValueConcrete = type.getRawType().getName().contains("AutoValue_") && this.type.getRawType().isAssignableFrom(type.getRawType());
            if (!isTypeEqual && !isAutoValueConcrete) {
                throw new CannotProvideCoderException(String.format("Unable to provide coder for %s, this factory can only provide coders for %s", type, this.type));
            }
            return this.coder;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("type", this.type).add("coder", this.coder).toString();
        }
    }

    private static class CoderProviderFromStaticMethods
    extends CoderProvider {
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> rawType;
        private final @UnknownKeyFor @NonNull @Initialized Method factoryMethod;

        @Override
        @SuppressFBWarnings(value={"DCN_NULLPOINTER_EXCEPTION"})
        public <T> @UnknownKeyFor @NonNull @Initialized Coder<T> coderFor(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<T> type, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized List<@KeyForBottom @NonNull @Initialized ? extends @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> componentCoders) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
            if (!this.rawType.equals(type.getRawType())) {
                throw new CannotProvideCoderException(String.format("Unable to provide coder for %s, this factory can only provide coders for %s", type, this.rawType));
            }
            try {
                return (Coder)Preconditions.checkStateNotNull(this.factoryMethod.invoke(this.rawType, componentCoders.toArray()));
            }
            catch (ExceptionInInitializerError | IllegalAccessException | IllegalArgumentException | NullPointerException | InvocationTargetException exn) {
                throw new IllegalStateException("error when invoking Coder factory method " + this.factoryMethod, exn);
            }
        }

        private CoderProviderFromStaticMethods(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> rawType, /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coderClazz) {
            this.rawType = rawType;
            this.factoryMethod = CoderProviderFromStaticMethods.getFactoryMethod(coderClazz);
        }

        private static @UnknownKeyFor @NonNull @Initialized Method getFactoryMethod(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> coderClazz) {
            Method factoryMethodCandidate;
            int numTypeParameters = coderClazz.getTypeParameters().length;
            Object[] factoryMethodArgTypes = new Class[numTypeParameters];
            Arrays.fill(factoryMethodArgTypes, Coder.class);
            try {
                factoryMethodCandidate = coderClazz.getDeclaredMethod("of", (Class<?>[])factoryMethodArgTypes);
            }
            catch (NoSuchMethodException | SecurityException exn) {
                throw new IllegalArgumentException("cannot register Coder " + coderClazz + ": does not have an accessible method named 'of' with " + numTypeParameters + " arguments of Coder type", exn);
            }
            if (!Modifier.isStatic(factoryMethodCandidate.getModifiers())) {
                throw new IllegalArgumentException("cannot register Coder " + coderClazz + ": method named 'of' with " + numTypeParameters + " arguments of Coder type is not static");
            }
            if (!coderClazz.isAssignableFrom(factoryMethodCandidate.getReturnType())) {
                throw new IllegalArgumentException("cannot register Coder " + coderClazz + ": method named 'of' with " + numTypeParameters + " arguments of Coder type does not return a " + coderClazz);
            }
            try {
                if (!factoryMethodCandidate.isAccessible()) {
                    factoryMethodCandidate.setAccessible(true);
                }
            }
            catch (SecurityException exn) {
                throw new IllegalArgumentException("cannot register Coder " + coderClazz + ": method named 'of' with " + numTypeParameters + " arguments of Coder type is not accessible", exn);
            }
            return factoryMethodCandidate;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("rawType", this.rawType).add("factoryMethod", (Object)this.factoryMethod).toString();
        }
    }
}

