/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.aws2.common.RetryConfiguration;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
@Internal
public abstract class AsyncBatchWriteHandler<@UnknownKeyFor RecT, @UnknownKeyFor ResT> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(AsyncBatchWriteHandler.class);
    private final @UnknownKeyFor @NonNull @Initialized FluentBackoff backoff;
    private final @UnknownKeyFor @NonNull @Initialized int concurrentRequests;
    private final @UnknownKeyFor @NonNull @Initialized Stats stats;
    protected final @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<RecT>, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized List<ResT>>> submitFn;
    protected final @UnknownKeyFor @NonNull @Initialized Function<ResT, @UnknownKeyFor @NonNull @Initialized String> errorCodeFn;
    private @UnknownKeyFor @NonNull @Initialized AtomicBoolean hasErrored;
    private @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Throwable> asyncFailure;
    private @UnknownKeyFor @NonNull @Initialized Semaphore requestPermits;

    protected AsyncBatchWriteHandler(@UnknownKeyFor @NonNull @Initialized int concurrency, @UnknownKeyFor @NonNull @Initialized FluentBackoff backoff, @UnknownKeyFor @NonNull @Initialized Stats stats, @UnknownKeyFor @NonNull @Initialized Function<ResT, @UnknownKeyFor @NonNull @Initialized String> errorCodeFn, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<RecT>, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized List<ResT>>> submitFn) {
        this.backoff = backoff;
        this.concurrentRequests = concurrency;
        this.errorCodeFn = errorCodeFn;
        this.submitFn = submitFn;
        this.hasErrored = new AtomicBoolean(false);
        this.asyncFailure = new AtomicReference();
        this.requestPermits = new Semaphore(this.concurrentRequests);
        this.stats = stats;
    }

    public final @UnknownKeyFor @NonNull @Initialized int requestsInProgress() {
        return this.concurrentRequests - this.requestPermits.availablePermits();
    }

    public final void reset() {
        this.hasErrored = new AtomicBoolean(false);
        this.asyncFailure = new AtomicReference();
        this.requestPermits = new Semaphore(this.concurrentRequests);
    }

    public final @UnknownKeyFor @NonNull @Initialized boolean hasErrored() {
        return this.hasErrored.get();
    }

    public final void checkForAsyncFailure() throws @UnknownKeyFor @NonNull @Initialized Throwable {
        Throwable failure = this.asyncFailure.getAndSet(null);
        if (failure != null) {
            throw failure;
        }
    }

    public final void waitForCompletion() throws @UnknownKeyFor @NonNull @Initialized Throwable {
        this.requestPermits.acquireUninterruptibly(this.concurrentRequests);
        this.checkForAsyncFailure();
    }

    public final void batchWrite(@UnknownKeyFor @NonNull @Initialized String destination, @UnknownKeyFor @NonNull @Initialized List<RecT> records) throws @UnknownKeyFor @NonNull @Initialized Throwable {
        this.batchWrite(destination, records, true);
    }

    public final void batchWrite(@UnknownKeyFor @NonNull @Initialized String destination, @UnknownKeyFor @NonNull @Initialized List<RecT> records, @UnknownKeyFor @NonNull @Initialized boolean throwAsyncFailures) throws @UnknownKeyFor @NonNull @Initialized Throwable {
        if (!this.hasErrored()) {
            this.requestPermits.acquireUninterruptibly();
            new RetryHandler(destination, records).run();
        }
        if (throwAsyncFailures) {
            this.checkForAsyncFailure();
        }
    }

    protected abstract @UnknownKeyFor @NonNull @Initialized List<RecT> failedRecords(@UnknownKeyFor @NonNull @Initialized List<RecT> var1, @UnknownKeyFor @NonNull @Initialized List<ResT> var2);

    protected abstract @UnknownKeyFor @NonNull @Initialized boolean hasFailedRecords(@UnknownKeyFor @NonNull @Initialized List<ResT> var1);

    public static <RecT, ResT> @UnknownKeyFor @NonNull @Initialized AsyncBatchWriteHandler<RecT, ResT> byPosition(@UnknownKeyFor @NonNull @Initialized int concurrency, @UnknownKeyFor @NonNull @Initialized int partialRetries, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryConfiguration retry, @UnknownKeyFor @NonNull @Initialized Stats stats, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<RecT>, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized List<ResT>>> submitFn, @UnknownKeyFor @NonNull @Initialized Function<ResT, @UnknownKeyFor @NonNull @Initialized String> errorCodeFn) {
        FluentBackoff backoff = AsyncBatchWriteHandler.retryBackoff(partialRetries, retry);
        return AsyncBatchWriteHandler.byPosition(concurrency, backoff, stats, submitFn, errorCodeFn);
    }

    public static <RecT, ResT> @UnknownKeyFor @NonNull @Initialized AsyncBatchWriteHandler<RecT, ResT> byPosition(@UnknownKeyFor @NonNull @Initialized int concurrency, @UnknownKeyFor @NonNull @Initialized FluentBackoff backoff, @UnknownKeyFor @NonNull @Initialized Stats stats, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<RecT>, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized List<ResT>>> submitFn, @UnknownKeyFor @NonNull @Initialized Function<ResT, @UnknownKeyFor @NonNull @Initialized String> errorCodeFn) {
        return new AsyncBatchWriteHandler<RecT, ResT>(concurrency, backoff, stats, (Function)errorCodeFn, (BiFunction)submitFn){

            @Override
            protected @UnknownKeyFor @NonNull @Initialized boolean hasFailedRecords(@UnknownKeyFor @NonNull @Initialized List<ResT> results) {
                for (int i = 0; i < results.size(); ++i) {
                    if (this.errorCodeFn.apply(results.get(i)) == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            protected @UnknownKeyFor @NonNull @Initialized List<RecT> failedRecords(@UnknownKeyFor @NonNull @Initialized List<RecT> records, @UnknownKeyFor @NonNull @Initialized List<ResT> results) {
                int size = Math.min(records.size(), results.size());
                ArrayList filtered = new ArrayList();
                for (int i = 0; i < size; ++i) {
                    if (this.errorCodeFn.apply(results.get(i)) == null) continue;
                    filtered.add(records.get(i));
                }
                return filtered;
            }
        };
    }

    public static <RecT, ErrT> @UnknownKeyFor @NonNull @Initialized AsyncBatchWriteHandler<RecT, ErrT> byId(@UnknownKeyFor @NonNull @Initialized int concurrency, @UnknownKeyFor @NonNull @Initialized int partialRetries, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryConfiguration retry, @UnknownKeyFor @NonNull @Initialized Stats stats, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<RecT>, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized List<ErrT>>> submitFn, @UnknownKeyFor @NonNull @Initialized Function<ErrT, @UnknownKeyFor @NonNull @Initialized String> errorCodeFn, @UnknownKeyFor @NonNull @Initialized Function<RecT, @UnknownKeyFor @NonNull @Initialized String> recordIdFn, @UnknownKeyFor @NonNull @Initialized Function<ErrT, @UnknownKeyFor @NonNull @Initialized String> errorIdFn) {
        FluentBackoff backoff = AsyncBatchWriteHandler.retryBackoff(partialRetries, retry);
        return AsyncBatchWriteHandler.byId(concurrency, backoff, stats, submitFn, errorCodeFn, recordIdFn, errorIdFn);
    }

    public static <RecT, ErrT> @UnknownKeyFor @NonNull @Initialized AsyncBatchWriteHandler<RecT, ErrT> byId(@UnknownKeyFor @NonNull @Initialized int concurrency, @UnknownKeyFor @NonNull @Initialized FluentBackoff backoff, @UnknownKeyFor @NonNull @Initialized Stats stats, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized List<RecT>, @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized List<ErrT>>> submitFn, @UnknownKeyFor @NonNull @Initialized Function<ErrT, @UnknownKeyFor @NonNull @Initialized String> errorCodeFn, final @UnknownKeyFor @NonNull @Initialized Function<RecT, @UnknownKeyFor @NonNull @Initialized String> recordIdFn, final @UnknownKeyFor @NonNull @Initialized Function<ErrT, @UnknownKeyFor @NonNull @Initialized String> errorIdFn) {
        return new AsyncBatchWriteHandler<RecT, ErrT>(concurrency, backoff, stats, errorCodeFn, submitFn){

            @Override
            protected @UnknownKeyFor @NonNull @Initialized boolean hasFailedRecords(@UnknownKeyFor @NonNull @Initialized List<ErrT> errors) {
                return !errors.isEmpty();
            }

            @Override
            protected @UnknownKeyFor @NonNull @Initialized List<RecT> failedRecords(@UnknownKeyFor @NonNull @Initialized List<RecT> records, @UnknownKeyFor @NonNull @Initialized List<ErrT> errors) {
                HashSet ids = Sets.newHashSetWithExpectedSize((int)errors.size());
                errors.forEach(e -> ids.add((String)errorIdFn.apply(e)));
                ArrayList filtered = new ArrayList(errors.size());
                for (int i = 0; i < records.size(); ++i) {
                    Object rec = records.get(i);
                    if (!ids.contains(recordIdFn.apply(rec))) continue;
                    filtered.add(rec);
                    if (filtered.size() != errors.size()) continue;
                    return filtered;
                }
                return filtered;
            }
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized FluentBackoff retryBackoff(@UnknownKeyFor @NonNull @Initialized int retries, @Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized RetryConfiguration retry) {
        FluentBackoff backoff = FluentBackoff.DEFAULT.withMaxRetries(retries);
        if (retry != null) {
            if (retry.throttledBaseBackoff() != null) {
                backoff = backoff.withInitialBackoff(retry.throttledBaseBackoff());
            }
            if (retry.maxBackoff() != null) {
                backoff = backoff.withMaxBackoff(retry.maxBackoff());
            }
        }
        return backoff;
    }

    private class RetryHandler
    implements BiConsumer<List<ResT>, Throwable> {
        private final @UnknownKeyFor @NonNull @Initialized String destination;
        private final @UnknownKeyFor @NonNull @Initialized int totalRecords;
        private final @UnknownKeyFor @NonNull @Initialized BackOff backoff;
        private final @UnknownKeyFor @NonNull @Initialized long handlerStartTime;
        private @UnknownKeyFor @NonNull @Initialized long requestStartTime;
        private @UnknownKeyFor @NonNull @Initialized int requests;
        private @UnknownKeyFor @NonNull @Initialized List<RecT> records;

        RetryHandler(@UnknownKeyFor @NonNull @Initialized String destination, List<RecT> records) {
            this.destination = destination;
            this.totalRecords = records.size();
            this.records = records;
            this.backoff = AsyncBatchWriteHandler.this.backoff.backoff();
            this.handlerStartTime = DateTimeUtils.currentTimeMillis();
            this.requestStartTime = 0L;
            this.requests = 0;
        }

        void run() {
            if (!AsyncBatchWriteHandler.this.hasErrored.get()) {
                try {
                    ++this.requests;
                    this.requestStartTime = DateTimeUtils.currentTimeMillis();
                    AsyncBatchWriteHandler.this.submitFn.apply(this.destination, this.records).whenComplete((BiConsumer)this);
                }
                catch (Throwable e) {
                    this.setAsyncFailure(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(@UnknownKeyFor @NonNull @Initialized List<ResT> results, @UnknownKeyFor @NonNull @Initialized Throwable throwable) {
            block10: {
                try {
                    long now = DateTimeUtils.currentTimeMillis();
                    long latencyMillis = now - this.requestStartTime;
                    Stats stats = AsyncBatchWriteHandler.this.stats;
                    synchronized (stats) {
                        AsyncBatchWriteHandler.this.stats.addBatchWriteRequest(latencyMillis, this.requests > 1);
                    }
                    if (results == null || AsyncBatchWriteHandler.this.hasErrored.get()) break block10;
                    if (!AsyncBatchWriteHandler.this.hasFailedRecords(results)) {
                        AsyncBatchWriteHandler.this.requestPermits.release();
                        LOG.debug("Done writing {} records [{} ms, {} request(s)]", new Object[]{this.totalRecords, now - this.handlerStartTime, this.requests});
                        break block10;
                    }
                    try {
                        if (BackOffUtils.next((Sleeper)Sleeper.DEFAULT, (BackOff)this.backoff)) {
                            LOG.info(this.summarizeErrors("Attempting retry", results));
                            this.records = AsyncBatchWriteHandler.this.failedRecords(this.records, results);
                            this.run();
                            break block10;
                        }
                        throwable = new IOException(this.summarizeErrors("Exceeded retries", results));
                    }
                    catch (Throwable e) {
                        throwable = new IOException(this.summarizeErrors("Aborted retries", results), e);
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                }
            }
            if (throwable != null) {
                this.setAsyncFailure(throwable);
            }
        }

        private void setAsyncFailure(@UnknownKeyFor @NonNull @Initialized Throwable throwable) {
            LOG.warn("Error when writing batch.", throwable);
            AsyncBatchWriteHandler.this.hasErrored.set(true);
            AsyncBatchWriteHandler.this.asyncFailure.updateAndGet(ex -> {
                if (ex != null) {
                    throwable.addSuppressed((Throwable)ex);
                }
                return throwable;
            });
            AsyncBatchWriteHandler.this.requestPermits.release(AsyncBatchWriteHandler.this.concurrentRequests);
        }

        private @UnknownKeyFor @NonNull @Initialized String summarizeErrors(@UnknownKeyFor @NonNull @Initialized String prefix, @UnknownKeyFor @NonNull @Initialized List<ResT> results) {
            Map countsPerError = results.stream().map(AsyncBatchWriteHandler.this.errorCodeFn).filter((Predicate<String>)Predicates.notNull()).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
            return countsPerError.entrySet().stream().map(kv -> String.format("code %s for %d record(s)", kv.getKey(), kv.getValue())).collect(Collectors.joining(", ", prefix + " after partial failure: ", "."));
        }
    }

    public static interface Stats {
        public static final @UnknownKeyFor @NonNull @Initialized Stats NONE = new Stats(){};

        default public void addBatchWriteRequest(@UnknownKeyFor @NonNull @Initialized long latencyMillis, @UnknownKeyFor @NonNull @Initialized boolean isPartialRetry) {
        }
    }
}

