/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.pkg;

import java.util.Map;
import org.odftoolkit.odfdom.pkg.OdfPackage;
import org.odftoolkit.odfdom.pkg.OdfPackageConstraint;
import org.odftoolkit.odfdom.pkg.manifest.Algorithm;
import org.odftoolkit.odfdom.pkg.manifest.EncryptionData;
import org.odftoolkit.odfdom.pkg.manifest.KeyDerivation;
import org.odftoolkit.odfdom.pkg.manifest.OdfFileEntry;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

class OdfManifestSaxHandler
implements ContentHandler {
    private OdfFileEntry _currentFileEntry;
    private EncryptionData _currentEncryptionData;
    private OdfPackage mPackage;
    private static final String EMPTY_STRING = "";

    public OdfManifestSaxHandler(OdfPackage pkg) {
        this.mPackage = pkg;
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        Map<String, OdfFileEntry> entries = this.mPackage.getManifestEntries();
        if (localName.equals("file-entry")) {
            String path = atts.getValue("manifest:full-path");
            if (path.equals(EMPTY_STRING) && this.mPackage.getErrorHandler() != null) {
                this.mPackage.logValidationError(OdfPackageConstraint.MANIFEST_WITH_EMPTY_PATH, this.mPackage.getBaseURI(), new Object[0]);
            }
            path = OdfPackage.normalizePath(path);
            this._currentFileEntry = entries.get(path);
            if (this._currentFileEntry == null) {
                this._currentFileEntry = new OdfFileEntry();
            }
            if (path != null) {
                entries.put(path, this._currentFileEntry);
            }
            this._currentFileEntry.setPath(atts.getValue("manifest:full-path"));
            this._currentFileEntry.setMediaTypeString(atts.getValue("manifest:media-type"));
            if (atts.getValue("manifest:size") != null) {
                try {
                    this._currentFileEntry.setSize(Integer.parseInt(atts.getValue("manifest:size")));
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException("not a number: " + atts.getValue("manifest:size") + nfe.getMessage());
                }
            }
        } else if (localName.equals("encryption-data")) {
            this._currentEncryptionData = new EncryptionData();
            if (this._currentFileEntry != null) {
                this._currentEncryptionData.setChecksumType(atts.getValue("manifest:checksum-type"));
                this._currentEncryptionData.setChecksum(atts.getValue("manifest:checksum"));
                this._currentFileEntry.setEncryptionData(this._currentEncryptionData);
            }
        } else if (localName.equals("algorithm")) {
            Algorithm algorithm = new Algorithm();
            algorithm.setName(atts.getValue("manifest:algorithm-name"));
            algorithm.setInitializationVector(atts.getValue("manifest:initialization-vector"));
            if (this._currentEncryptionData != null) {
                this._currentEncryptionData.setAlgorithm(algorithm);
            }
        } else if (localName.equals("key-derivation")) {
            KeyDerivation keyDerivation = new KeyDerivation();
            keyDerivation.setName(atts.getValue("manifest:key-derivation-name"));
            keyDerivation.setSalt(atts.getValue("manifest:salt"));
            if (atts.getValue("manifest:iteration-count") != null) {
                try {
                    keyDerivation.setIterationCount(Integer.parseInt(atts.getValue("manifest:iteration-count")));
                }
                catch (NumberFormatException nfe) {
                    throw new SAXException("not a number: " + atts.getValue("manifest:iteration-count"));
                }
            }
            if (this._currentEncryptionData != null) {
                this._currentEncryptionData.setKeyDerivation(keyDerivation);
            }
        } else if (localName.equals("manifest")) {
            this.mPackage.setManifestVersion(atts.getValue("manifest:version"));
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (localName.equals("encryption-data")) {
            this._currentEncryptionData = null;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }
}

