/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.CheckForNull;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.DoFnRunnerFactory;
import org.apache.beam.runners.spark.structuredstreaming.translation.utils.ScalaInterop;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.WindowedValueMultiReceiver;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.AbstractIterator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterator;

abstract class DoFnPartitionIteratorFactory<@UnknownKeyFor InT, @UnknownKeyFor FnOutT, @UnknownKeyFor OutT>
implements Function1<Iterator<WindowedValue<InT>>, Iterator<OutT>>,
Serializable {
    protected final @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, FnOutT> factory;
    protected final @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options;
    private final @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics;

    private DoFnPartitionIteratorFactory(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, FnOutT> factory) {
        this.options = options;
        this.metrics = metrics;
        this.factory = factory;
    }

    static <InT, OutT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFnPartitionIteratorFactory<InT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized WindowedValue<OutT>> singleOutput(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, OutT> factory) {
        return new SingleOut(options, metrics, factory);
    }

    static <InT, FnOutT, OutT> /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DoFnPartitionIteratorFactory<InT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, @UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized WindowedValue<OutT>>> multiOutput(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, FnOutT> factory, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> tagColIdx) {
        return new MultiOut(options, metrics, factory, tagColIdx);
    }

    public @UnknownKeyFor @NonNull @Initialized Iterator<OutT> apply(@UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>> it) {
        return it.hasNext() ? ScalaInterop.scalaIterator(new DoFnPartitionIt(it)) : Iterator.empty();
    }

    abstract @UnknownKeyFor @NonNull @Initialized WindowedValueMultiReceiver outputManager(@UnknownKeyFor @NonNull @Initialized Deque<OutT> var1);

    private class DoFnPartitionIt
    extends AbstractIterator<OutT> {
        private final @UnknownKeyFor @NonNull @Initialized Deque<OutT> buffer = new ArrayDeque();
        private final /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory.DoFnRunnerWithTeardown<InT, @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> doFnRunner;
        private final @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<InT>> partitionIt;
        private @UnknownKeyFor @NonNull @Initialized boolean isBundleFinished;

        private DoFnPartitionIt(Iterator<WindowedValue<InT>> partitionIt) {
            this.partitionIt = partitionIt;
            this.doFnRunner = DoFnPartitionIteratorFactory.this.factory.create(DoFnPartitionIteratorFactory.this.options.get(), DoFnPartitionIteratorFactory.this.metrics, DoFnPartitionIteratorFactory.this.outputManager(this.buffer));
        }

        @CheckForNull
        protected @Nullable OutT computeNext() {
            try {
                while (true) {
                    if (!this.buffer.isEmpty()) {
                        return this.buffer.remove();
                    }
                    if (this.partitionIt.hasNext()) {
                        this.doFnRunner.processElement((WindowedValue)this.partitionIt.next());
                        continue;
                    }
                    if (this.isBundleFinished) break;
                    this.isBundleFinished = true;
                    this.doFnRunner.finishBundle();
                }
                this.doFnRunner.teardown();
                return this.endOfData();
            }
            catch (RuntimeException re) {
                this.doFnRunner.teardown();
                throw re;
            }
        }
    }

    private static class MultiOut<@UnknownKeyFor InT, @UnknownKeyFor FnOutT, @UnknownKeyFor OutT>
    extends DoFnPartitionIteratorFactory<InT, FnOutT, Tuple2<Integer, WindowedValue<OutT>>> {
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> tagColIdx;

        public MultiOut(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, FnOutT> factory, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer> tagColIdx) {
            super(options, metrics, factory);
            this.tagColIdx = tagColIdx;
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized WindowedValueMultiReceiver outputManager(final @UnknownKeyFor @NonNull @Initialized Deque<@UnknownKeyFor @NonNull @Initialized Tuple2<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized WindowedValue<OutT>>> buffer) {
            return new WindowedValueMultiReceiver(){

                public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
                    Integer columnIdx = (Integer)tagColIdx.get(tag.getId());
                    if (columnIdx != null) {
                        buffer.add(ScalaInterop.tuple(columnIdx, output));
                    }
                }
            };
        }
    }

    private static class SingleOut<@UnknownKeyFor InT, @UnknownKeyFor OutT>
    extends DoFnPartitionIteratorFactory<InT, OutT, WindowedValue<OutT>> {
        private SingleOut(@UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized PipelineOptions> options, @UnknownKeyFor @NonNull @Initialized MetricsAccumulator metrics, @UnknownKeyFor @NonNull @Initialized DoFnRunnerFactory<InT, OutT> factory) {
            super(options, metrics, factory);
        }

        @Override
        @UnknownKeyFor @NonNull @Initialized WindowedValueMultiReceiver outputManager(final @UnknownKeyFor @NonNull @Initialized Deque<@UnknownKeyFor @NonNull @Initialized WindowedValue<OutT>> buffer) {
            return new WindowedValueMultiReceiver(){

                public <T> void output(@UnknownKeyFor @NonNull @Initialized TupleTag<T> tag, @UnknownKeyFor @NonNull @Initialized WindowedValue<T> output) {
                    buffer.add(output);
                }
            };
        }
    }
}

