/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.helpers;

import java.io.IOException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.util.CoderUtils;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public final class CoderHelpers {
    private CoderHelpers() {
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] toByteArray(T value, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        try {
            return CoderUtils.encodeToByteArray(coder, value);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding value: " + value, e);
        }
    }

    public static <T> T fromByteArray(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] serialized, @UnknownKeyFor @NonNull @Initialized Coder<T> coder) {
        try {
            return (T)CoderUtils.decodeFromByteArray(coder, (byte[])serialized);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error decoding bytes for coder: " + coder, e);
        }
    }
}

