/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.catalog.systemviews;

import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Supplier;
import org.apache.ignite.internal.catalog.Catalog;
import org.apache.ignite.internal.catalog.CatalogSystemViewProvider;
import org.apache.ignite.internal.catalog.descriptors.CatalogObjectDescriptor;
import org.apache.ignite.internal.systemview.api.ClusterSystemView;
import org.apache.ignite.internal.systemview.api.SystemView;
import org.apache.ignite.internal.systemview.api.SystemViews;
import org.apache.ignite.internal.type.NativeTypes;
import org.apache.ignite.internal.util.SubscriptionUtils;

public class SchemasSystemViewProvider
implements CatalogSystemViewProvider {
    @Override
    public List<SystemView<?>> getView(Supplier<Catalog> catalogSupplier) {
        return List.of(SchemasSystemViewProvider.getSchemasSystemView(catalogSupplier));
    }

    private static SystemView<?> getSchemasSystemView(Supplier<Catalog> catalogSupplier) {
        Iterable tablesData = () -> {
            Catalog catalog = (Catalog)catalogSupplier.get();
            return catalog.schemas().stream().iterator();
        };
        Flow.Publisher viewDataPublisher = SubscriptionUtils.fromIterable(tablesData);
        return ((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)((ClusterSystemView.Builder)SystemViews.clusterViewBuilder().name("SCHEMAS")).addColumn("SCHEMA_ID", NativeTypes.INT32, CatalogObjectDescriptor::id)).addColumn("SCHEMA_NAME", NativeTypes.STRING, CatalogObjectDescriptor::name)).dataProvider(viewDataPublisher)).build();
    }
}

