/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.verify;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.CacheEntryVersion;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.binary.BinaryObjectEx;
import org.apache.ignite.internal.management.cache.PartitionKeyV2;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.processors.cache.CacheGroupContext;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.PartitionUpdateCounter;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtLocalPartition;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionState;
import org.apache.ignite.internal.processors.cache.distributed.dht.topology.GridDhtPartitionTopology;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStore;
import org.apache.ignite.internal.processors.cache.persistence.file.FilePageStoreManager;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.IncrementalSnapshotVerificationTask;
import org.apache.ignite.internal.processors.cache.verify.GridNotIdleException;
import org.apache.ignite.internal.processors.cache.verify.PartitionHashRecordV2;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.lang.IgniteThrowableSupplier;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.lang.IgniteInClosure;
import org.jetbrains.annotations.Nullable;

public class IdleVerifyUtility {
    public static final String GRID_NOT_IDLE_MSG = "Cluster not idle. Modifications found in caches or groups: ";

    public static void checkPartitionsPageCrcSum(IgniteThrowableSupplier<FilePageStore> pageStoreSup, int partId, byte pageType) {
        IdleVerifyUtility.checkPartitionsPageCrcSum(pageStoreSup, partId, pageType, null);
    }

    public static void checkPartitionsPageCrcSum(IgniteThrowableSupplier<FilePageStore> pageStoreSup, int partId, byte pageType, @Nullable BiConsumer<Long, ByteBuffer> pagePostProc) {
        assert (pageType == 1 || pageType == 2 || pageType == 4) : pageType;
        FilePageStore pageStore = null;
        try {
            pageStore = pageStoreSup.get();
            long pageId = PageIdUtils.pageId(partId, (byte)0, 0);
            ByteBuffer buf = ByteBuffer.allocateDirect(pageStore.getPageSize()).order(ByteOrder.nativeOrder());
            for (int pageNo = 0; pageNo < pageStore.pages(); ++pageNo) {
                buf.clear();
                pageStore.read(pageId, buf, true, true);
                if (pagePostProc != null) {
                    pagePostProc.accept(pageId, buf);
                }
                ++pageId;
            }
        }
        catch (Throwable e) {
            String msg0 = "CRC check of partition failed [partId=" + partId + ", grpName=" + (pageStore == null ? "" : FilePageStoreManager.cacheGroupName(new File(pageStore.getFileAbsolutePath()).getParentFile())) + ", part=" + (pageStore == null ? "" : pageStore.getFileAbsolutePath()) + "]";
            throw new IgniteException(msg0, e);
        }
    }

    public static Map<Integer, Map<Integer, PartitionUpdateCounter>> getUpdateCountersSnapshot(IgniteEx ign, Set<Integer> grpIds) {
        HashMap<Integer, Map<Integer, PartitionUpdateCounter>> partsWithCountersPerGrp = new HashMap<Integer, Map<Integer, PartitionUpdateCounter>>();
        for (Integer grpId : grpIds) {
            CacheGroupContext grpCtx = ign.context().cache().cacheGroup(grpId);
            if (grpCtx == null) {
                throw new GridNotIdleException("Group not found: " + grpId + ". Possible reasons: rebalance in progress or concurrent cache destroy.");
            }
            GridDhtPartitionTopology top = grpCtx.topology();
            Map partsWithCounters = partsWithCountersPerGrp.computeIfAbsent(grpId, k -> new HashMap());
            for (GridDhtLocalPartition part : top.currentLocalPartitions()) {
                if (part.state() != GridDhtPartitionState.OWNING) continue;
                @Nullable PartitionUpdateCounter updCntr = part.dataStore().partUpdateCounter();
                partsWithCounters.put(part.id(), updCntr == null ? null : updCntr.copy());
            }
        }
        return partsWithCountersPerGrp;
    }

    public static String formatUpdateCountersDiff(IgniteEx ig, List<Integer> diff) {
        SB sb = null;
        if (!diff.isEmpty()) {
            sb = new SB();
            for (int grpId0 : diff) {
                if (sb.length() != 0) {
                    sb.a(", ");
                } else {
                    sb.a("\"");
                }
                DynamicCacheDescriptor desc = ig.context().cache().cacheDescriptor(grpId0);
                CacheGroupContext grpCtx = ig.context().cache().cacheGroup(desc == null ? grpId0 : desc.groupId());
                sb.a(grpCtx.cacheOrGroupName());
            }
            sb.a("\"");
        }
        return sb != null ? sb.toString() : "";
    }

    public static List<Integer> compareUpdateCounters(IgniteEx ign, Map<Integer, Map<Integer, PartitionUpdateCounter>> cntrsIn, Integer grpId) {
        Map<Integer, Map<Integer, PartitionUpdateCounter>> curCntrs = IdleVerifyUtility.getUpdateCountersSnapshot(ign, Collections.singleton(grpId));
        if (curCntrs.isEmpty()) {
            throw new GridNotIdleException("No OWNING partitions for group: " + grpId);
        }
        return IdleVerifyUtility.compareUpdateCounters(ign, cntrsIn, curCntrs);
    }

    public static List<Integer> compareUpdateCounters(IgniteEx ign, Map<Integer, Map<Integer, PartitionUpdateCounter>> cntrsEth, Map<Integer, Map<Integer, PartitionUpdateCounter>> curCntrs) {
        ArrayList<Integer> diff = new ArrayList<Integer>();
        for (Map.Entry<Integer, Map<Integer, PartitionUpdateCounter>> curEntry : curCntrs.entrySet()) {
            Map<Integer, PartitionUpdateCounter> partsWithCntrsCur = curEntry.getValue();
            Integer grpId = curEntry.getKey();
            if (partsWithCntrsCur == null) {
                throw new GridNotIdleException("Group not found: " + grpId + ". Possible reasons: rebalance in progress or concurrent cache destroy.");
            }
            Map<Integer, PartitionUpdateCounter> partsWithCntrsIn = cntrsEth.get(grpId);
            if (partsWithCntrsIn.equals(partsWithCntrsCur)) continue;
            diff.add(grpId);
        }
        return diff;
    }

    @Nullable
    public static PartitionHashRecordV2 calculatePartitionHash(PartitionKeyV2 partKey, Object updCntr, Object consId, GridDhtPartitionState state, boolean isPrimary, long partSize, GridIterator<CacheDataRow> it) throws IgniteCheckedException {
        if (state == GridDhtPartitionState.MOVING || state == GridDhtPartitionState.LOST) {
            return new PartitionHashRecordV2(partKey, isPrimary, consId, updCntr, state == GridDhtPartitionState.MOVING ? Long.MIN_VALUE : 0L, state == GridDhtPartitionState.MOVING ? PartitionHashRecordV2.PartitionState.MOVING : PartitionHashRecordV2.PartitionState.LOST, new VerifyPartitionContext());
        }
        if (state != GridDhtPartitionState.OWNING) {
            return null;
        }
        VerifyPartitionContext ctx = new VerifyPartitionContext();
        while (it.hasNextX()) {
            CacheDataRow row = it.nextX();
            if (row.expireTime() > 0L) continue;
            ctx.update(row.key(), row.value(), row.version());
        }
        return new PartitionHashRecordV2(partKey, isPrimary, consId, updCntr, partSize, PartitionHashRecordV2.PartitionState.OWNING, ctx);
    }

    private IdleVerifyUtility() {
    }

    public static class VerifyPartitionContext {
        public int partHash;
        public int partVerHash;
        public int cf;
        public int noCf;
        public int binary;
        public int regular;

        public VerifyPartitionContext() {
        }

        public VerifyPartitionContext(IncrementalSnapshotVerificationTask.HashHolder hash) {
            this.partHash = hash.hash;
            this.partVerHash = hash.verHash;
        }

        public void update(KeyCacheObject key, CacheObject val, CacheEntryVersion ver) throws IgniteCheckedException {
            this.partHash += key.hashCode();
            if (ver != null) {
                this.partVerHash += ver.hashCode();
            }
            this.partHash += Arrays.hashCode(val.valueBytes(null));
            if (key.cacheObjectType() == 100) {
                ++this.binary;
                if (((BinaryObjectEx)((Object)key)).isFlagSet((short)32)) {
                    ++this.cf;
                } else {
                    ++this.noCf;
                }
            } else {
                ++this.regular;
            }
        }
    }

    public static class IdleChecker
    implements IgniteInClosure<Integer> {
        private static final long serialVersionUID = 0L;
        private final IgniteEx ig;
        private final Map<Integer, Map<Integer, PartitionUpdateCounter>> partsWithCntrsPerGrp;

        public IdleChecker(IgniteEx ig, Map<Integer, Map<Integer, PartitionUpdateCounter>> partsWithCntrsPerGrp) {
            this.ig = ig;
            this.partsWithCntrsPerGrp = partsWithCntrsPerGrp;
        }

        @Override
        public void apply(Integer grpId) {
            String res;
            List<Integer> diff = IdleVerifyUtility.compareUpdateCounters(this.ig, this.partsWithCntrsPerGrp, grpId);
            if (!F.isEmpty(diff) && !(res = IdleVerifyUtility.formatUpdateCountersDiff(this.ig, diff)).isEmpty()) {
                throw new GridNotIdleException("Cluster not idle. Modifications found in caches or groups: [" + res + "]");
            }
        }
    }
}

