/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basecrdt.core.internal;

import com.google.common.collect.Sets;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableEmitter;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.bifromq.basecrdt.core.api.ICRDTOperation;
import org.apache.bifromq.basecrdt.core.api.ICausalCRDT;
import org.apache.bifromq.basecrdt.core.internal.IDotStore;
import org.apache.bifromq.basecrdt.proto.Replica;
import org.apache.bifromq.basecrdt.proto.StateLattice;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CausalCRDT<T extends IDotStore, O extends ICRDTOperation>
implements ICausalCRDT<O> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CausalCRDT.class);
    private final Set<ObservableEmitter<Long>> emitters = Sets.newConcurrentHashSet();
    protected final Replica replica;
    protected final CRDTOperationExecutor<O> executor;
    protected final DotStoreAccessor<T> dotStoreAccessor;

    CausalCRDT(Replica replica, DotStoreAccessor<T> dotStoreAccessor, CRDTOperationExecutor<O> executor) {
        this.replica = replica;
        this.dotStoreAccessor = dotStoreAccessor;
        this.executor = executor;
    }

    @Override
    public Replica id() {
        return this.replica;
    }

    @Override
    public final CompletableFuture<Void> execute(O op) {
        return this.executor.submit(op);
    }

    @Override
    public final Observable<Long> inflation() {
        return Observable.create(emitter -> {
            this.emitters.add((ObservableEmitter<Long>)emitter);
            emitter.setCancellable(() -> this.emitters.remove(emitter));
        });
    }

    final void afterInflation(Iterable<StateLattice> addEvents, Iterable<StateLattice> removeEvents) {
        this.handleInflation(addEvents, removeEvents);
        long ts = System.nanoTime();
        this.emitters.forEach(e -> e.onNext((Object)ts));
    }

    protected void handleInflation(Iterable<StateLattice> addEvents, Iterable<StateLattice> removeEvents) {
    }

    public String toString() {
        return this.dotStoreAccessor.fetch().toString();
    }

    static interface DotStoreAccessor<T extends IDotStore> {
        public T fetch();
    }

    static interface CRDTOperationExecutor<O extends ICRDTOperation> {
        public CompletableFuture<Void> submit(O var1);
    }
}

