/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.demo.plugin;

import com.sun.net.httpserver.HttpServer;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.config.MeterFilter;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.prometheus.PrometheusConfig;
import io.micrometer.prometheus.PrometheusMeterRegistry;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.time.Duration;
import lombok.Generated;
import org.apache.bifromq.demo.plugin.DemoPluginContext;
import org.apache.bifromq.demo.plugin.util.VariableUtil;
import org.apache.bifromq.plugin.BifroMQPlugin;
import org.apache.bifromq.plugin.BifroMQPluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DemoPlugin
extends BifroMQPlugin<DemoPluginContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DemoPlugin.class);
    private final PrometheusMeterRegistry registry;
    private final HttpServer prometheusExportServer;
    private final Thread serverThread;
    private final int exportPort = VariableUtil.getPort();

    public DemoPlugin(BifroMQPluginDescriptor context) {
        super(context);
        this.registry = new PrometheusMeterRegistry(PrometheusConfig.DEFAULT);
        this.registry.config().meterFilter(new MeterFilter(){

            public DistributionStatisticConfig configure(Meter.Id id, DistributionStatisticConfig config) {
                switch (id.getType()) {
                    default: 
                }
                return DistributionStatisticConfig.builder().expiry(Duration.ofSeconds(5L)).build().merge(config);
            }
        });
        Metrics.addRegistry((MeterRegistry)this.registry);
        try {
            this.prometheusExportServer = HttpServer.create(new InetSocketAddress(this.exportPort), 0);
            this.prometheusExportServer.createContext(VariableUtil.getContext(), httpExchange -> {
                String response = this.registry.scrape();
                httpExchange.sendResponseHeaders(200, response.getBytes().length);
                try (OutputStream os = httpExchange.getResponseBody();){
                    os.write(response.getBytes());
                }
            });
            this.serverThread = new Thread(this.prometheusExportServer::start);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected void doStart() {
        this.serverThread.start();
        log.info("Prometheus exporter started on port {}", (Object)this.exportPort);
    }

    protected void doStop() {
        this.prometheusExportServer.stop(0);
        Metrics.removeRegistry((MeterRegistry)this.registry);
        log.info("Prometheus exporter stopped");
    }
}

