/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.profile;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.security.RolesAllowed;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.AuthManager;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

@Path(value="whiteiplist")
@Singleton
@Tag(name="WhiteIpListAPI")
public class WhiteIpListAPI
extends API {
    private static final Logger LOG = Log.logger(WhiteIpListAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    @Operation(summary="list white ips")
    public Map<String, Object> list(@Context GraphManager manager) {
        LOG.debug("List white ips");
        AuthManager authManager = manager.authManager();
        Set whiteIpList = authManager.listWhiteIPs();
        return ImmutableMap.of((Object)"whiteIpList", (Object)whiteIpList);
    }

    @POST
    @Timed
    @StatusFilter.Status(value=202)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    @Operation(summary="update white ip list")
    public Map<String, Object> updateWhiteIPs(@Context GraphManager manager, Map<String, Object> actionMap) {
        E.checkArgument((actionMap != null ? 1 : 0) != 0, (String)"Missing argument: actionMap", (Object[])new Object[0]);
        Set whiteIpList = manager.authManager().listWhiteIPs();
        Object ipListRaw = actionMap.get("ips");
        E.checkArgument((boolean)(ipListRaw instanceof List), (String)"Invalid ips type '%s', must be list", (Object[])new Object[]{ipListRaw.getClass()});
        List ipList = (List)ipListRaw;
        Object actionRaw = actionMap.get("action");
        E.checkArgument((actionRaw != null ? 1 : 0) != 0, (String)"Missing argument: action", (Object[])new Object[0]);
        E.checkArgument((boolean)(actionRaw instanceof String), (String)"Invalid action type '%s', must be string", (Object[])new Object[]{actionRaw.getClass()});
        String action = (String)actionRaw;
        E.checkArgument((boolean)StringUtils.isNotEmpty((String)action), (String)"Missing argument: action", (Object[])new Object[0]);
        HashSet<String> existedIPs = new HashSet<String>();
        HashSet<String> loadedIPs = new HashSet<String>();
        HashSet<String> illegalIPs = new HashSet<String>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (String ip : ipList) {
            if (whiteIpList.contains(ip)) {
                existedIPs.add(ip);
                continue;
            }
            if (!"load".equals(action)) continue;
            boolean bl = this.checkIp(ip) ? loadedIPs.add(ip) : illegalIPs.add(ip);
        }
        switch (action) {
            case "load": {
                LOG.debug("Load to white ip list");
                result.put("existed_ips", existedIPs);
                result.put("added_ips", loadedIPs);
                if (!illegalIPs.isEmpty()) {
                    result.put("illegal_ips", illegalIPs);
                }
                whiteIpList.addAll(loadedIPs);
                break;
            }
            case "remove": {
                LOG.debug("Remove from white ip list");
                result.put("removed_ips", existedIPs);
                result.put("non_existed_ips", loadedIPs);
                whiteIpList.removeAll(existedIPs);
                break;
            }
            default: {
                throw new AssertionError((Object)String.format("Invalid action '%s', supported action is 'load' or 'remove'", action));
            }
        }
        manager.authManager().setWhiteIPs(whiteIpList);
        return result;
    }

    @PUT
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    @RolesAllowed(value={"admin"})
    @Operation(summary="enable/disable the white ip list")
    public Map<String, Object> updateStatus(@Context GraphManager manager, @QueryParam(value="status") String status) {
        LOG.debug("Enable or disable white ip list");
        E.checkArgument(("true".equals(status) || "false".equals(status) ? 1 : 0) != 0, (String)"Invalid status, valid status is 'true' or 'false'", (Object[])new Object[0]);
        boolean open = Boolean.parseBoolean(status);
        manager.authManager().enabledWhiteIpList(open);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("WhiteIpListOpen", open);
        return map;
    }

    private boolean checkIp(String ipStr) {
        String ip = "^(1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|[1-9])\\.(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)\\.(00?\\d|1\\d{2}|2[0-4]\\d|25[0-5]|[1-9]\\d|\\d)$";
        Pattern pattern = Pattern.compile(ip);
        Matcher matcher = pattern.matcher(ipStr);
        return matcher.matches();
    }
}

