/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.grpc;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.AbstractBlockingStub;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.hugegraph.store.HgKvEntry;
import org.apache.hugegraph.store.HgKvIterator;
import org.apache.hugegraph.store.HgOwnerKey;
import org.apache.hugegraph.store.HgScanQuery;
import org.apache.hugegraph.store.client.HgStoreNodeSession;
import org.apache.hugegraph.store.client.grpc.AbstractGrpcClient;
import org.apache.hugegraph.store.client.grpc.KvBatchOneShotScanner;
import org.apache.hugegraph.store.client.grpc.KvBatchScanner;
import org.apache.hugegraph.store.client.grpc.KvBatchScanner5;
import org.apache.hugegraph.store.client.grpc.KvCloseableIterator;
import org.apache.hugegraph.store.client.grpc.KvOneShotScanner;
import org.apache.hugegraph.store.client.grpc.KvPageScanner;
import org.apache.hugegraph.store.grpc.common.Kv;
import org.apache.hugegraph.store.grpc.stream.HgStoreStreamGrpc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class GrpcStoreStreamClient
extends AbstractGrpcClient {
    private static final Logger log = LoggerFactory.getLogger(GrpcStoreStreamClient.class);

    public HgStoreStreamGrpc.HgStoreStreamStub getStub(HgStoreNodeSession nodeSession) {
        return (HgStoreStreamGrpc.HgStoreStreamStub)this.getAsyncStub(nodeSession.getStoreNode().getAddress());
    }

    @Override
    public AbstractAsyncStub getAsyncStub(ManagedChannel channel) {
        return HgStoreStreamGrpc.newStub((Channel)channel);
    }

    private HgStoreStreamGrpc.HgStoreStreamBlockingStub getBlockingStub(HgStoreNodeSession nodeSession) {
        return (HgStoreStreamGrpc.HgStoreStreamBlockingStub)this.getBlockingStub(nodeSession.getStoreNode().getAddress());
    }

    @Override
    public AbstractBlockingStub getBlockingStub(ManagedChannel channel) {
        return HgStoreStreamGrpc.newBlockingStub((Channel)channel);
    }

    KvCloseableIterator<Kv> doScanOneShot(HgStoreNodeSession nodeSession, String table, long limit, byte[] query) {
        return KvOneShotScanner.scanAll(nodeSession, this.getBlockingStub(nodeSession), table, limit, query);
    }

    KvCloseableIterator<Kv> doScanOneShot(HgStoreNodeSession nodeSession, String table, long limit) {
        return KvOneShotScanner.scanAll(nodeSession, this.getBlockingStub(nodeSession), table, limit, null);
    }

    KvCloseableIterator<Kv> doScanOneShot(HgStoreNodeSession nodeSession, String table, HgOwnerKey prefix, long limit) {
        return KvOneShotScanner.scanPrefix(nodeSession, this.getBlockingStub(nodeSession), table, prefix, limit, null);
    }

    KvCloseableIterator<Kv> doScanOneShot(HgStoreNodeSession nodeSession, String table, HgOwnerKey prefix, long limit, byte[] query) {
        return KvOneShotScanner.scanPrefix(nodeSession, this.getBlockingStub(nodeSession), table, prefix, limit, query);
    }

    KvCloseableIterator<Kv> doScanOneShot(HgStoreNodeSession nodeSession, String table, HgOwnerKey startKey, HgOwnerKey endKey, long limit, int scanType, byte[] query) {
        return KvOneShotScanner.scanRange(nodeSession, this.getBlockingStub(nodeSession), table, startKey, endKey, limit, scanType, query);
    }

    KvCloseableIterator<Kv> doScan(HgStoreNodeSession nodeSession, String table, long limit, byte[] query) {
        return KvPageScanner.scanAll(nodeSession, this.getStub(nodeSession), table, limit, query);
    }

    KvCloseableIterator<Kv> doScan(HgStoreNodeSession nodeSession, String table, long limit) {
        return KvPageScanner.scanAll(nodeSession, this.getStub(nodeSession), table, limit, null);
    }

    KvCloseableIterator<Kv> doScan(HgStoreNodeSession nodeSession, String table, HgOwnerKey prefix, long limit) {
        return KvPageScanner.scanPrefix(nodeSession, this.getStub(nodeSession), table, prefix, limit, null);
    }

    KvCloseableIterator<Kv> doScan(HgStoreNodeSession nodeSession, String table, HgOwnerKey prefix, long limit, byte[] query) {
        return KvPageScanner.scanPrefix(nodeSession, this.getStub(nodeSession), table, prefix, limit, query);
    }

    KvCloseableIterator<Kv> doScan(HgStoreNodeSession nodeSession, String table, HgOwnerKey startKey, HgOwnerKey endKey, long limit, int scanType, byte[] query) {
        return KvPageScanner.scanRange(nodeSession, this.getStub(nodeSession), table, startKey, endKey, limit, scanType, query);
    }

    KvCloseableIterator<Kv> doBatchScan(HgStoreNodeSession nodeSession, HgScanQuery scanQuery) {
        return KvBatchScanner5.scan(nodeSession, this.getStub(nodeSession), scanQuery);
    }

    KvCloseableIterator<HgKvIterator<HgKvEntry>> doBatchScan3(HgStoreNodeSession nodeSession, HgScanQuery scanQuery, KvCloseableIterator iterator) {
        KvBatchScanner.scan(this.getStub(nodeSession), nodeSession.getGraphName(), scanQuery, iterator);
        return iterator;
    }

    KvCloseableIterator<Kv> doBatchScanOneShot(HgStoreNodeSession nodeSession, HgScanQuery scanQuery) {
        return KvBatchOneShotScanner.scan(nodeSession, this.getBlockingStub(nodeSession), scanQuery);
    }
}

