/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.store.client.query;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.hugegraph.store.HgKvIterator;

public class MultiStreamIterator<E>
implements HgKvIterator<E> {
    private HgKvIterator<E> currentIterator = null;
    private final Iterator<HgKvIterator<E>> listIterator;

    public MultiStreamIterator(List<HgKvIterator<E>> iterators) {
        this.listIterator = iterators.iterator();
    }

    @Override
    public byte[] key() {
        return this.currentIterator.key();
    }

    @Override
    public byte[] value() {
        return this.currentIterator.value();
    }

    @Override
    public void close() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            this.currentIterator.close();
        }
    }

    @Override
    public byte[] position() {
        return this.currentIterator.position();
    }

    @Override
    public void seek(byte[] position) {
        this.currentIterator.seek(position);
    }

    private void getNextIterator() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return;
        }
        while (this.listIterator.hasNext()) {
            this.currentIterator = this.listIterator.next();
            if (!this.currentIterator.hasNext()) continue;
            break;
        }
    }

    @Override
    public boolean hasNext() {
        this.getNextIterator();
        return this.currentIterator != null && this.currentIterator.hasNext();
    }

    @Override
    public E next() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.currentIterator.next();
    }
}

