/*
 * Decompiled with CFR 0.152.
 */
package org.apdplat.word.segmentation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apdplat.word.corpus.Bigram;
import org.apdplat.word.corpus.Trigram;
import org.apdplat.word.dictionary.Dictionary;
import org.apdplat.word.dictionary.DictionaryFactory;
import org.apdplat.word.recognition.PersonName;
import org.apdplat.word.recognition.Punctuation;
import org.apdplat.word.segmentation.DictionaryBasedSegmentation;
import org.apdplat.word.segmentation.SegmentationAlgorithm;
import org.apdplat.word.segmentation.Word;
import org.apdplat.word.util.WordConfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSegmentation
implements DictionaryBasedSegmentation {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private static final boolean PERSON_NAME_RECOGNIZE = WordConfTools.getBoolean("person.name.recognize", true);
    private static final boolean KEEP_WHITESPACE = WordConfTools.getBoolean("keep.whitespace", false);
    private static final boolean KEEP_PUNCTUATION = WordConfTools.getBoolean("keep.punctuation", false);
    private static final boolean PARALLEL_SEG = WordConfTools.getBoolean("parallel.seg", true);
    private static final int INTERCEPT_LENGTH = WordConfTools.getInt("intercept.length", 16);
    private static final String NGRAM = WordConfTools.get("ngram", "bigram");
    private static Dictionary dictionary = DictionaryFactory.getDictionary();

    public boolean isParallelSeg() {
        return PARALLEL_SEG;
    }

    @Override
    public void setDictionary(Dictionary dictionary) {
        AbstractSegmentation.dictionary.clear();
        AbstractSegmentation.dictionary = dictionary;
    }

    @Override
    public Dictionary getDictionary() {
        return dictionary;
    }

    public abstract List<Word> segImpl(String var1);

    public boolean ngramEnabled() {
        return "bigram".equals(NGRAM) || "trigram".equals(NGRAM);
    }

    public Map<List<Word>, Float> ngram(List<Word> ... listArray) {
        if ("bigram".equals(NGRAM)) {
            return Bigram.bigram(listArray);
        }
        if ("trigram".equals(NGRAM)) {
            return Trigram.trigram(listArray);
        }
        return null;
    }

    public int getInterceptLength() {
        if (this.getDictionary().getMaxLength() > INTERCEPT_LENGTH) {
            return this.getDictionary().getMaxLength();
        }
        return INTERCEPT_LENGTH;
    }

    @Override
    public List<Word> seg(String string2) {
        List<String> list = Punctuation.seg(string2, KEEP_PUNCTUATION, new char[0]);
        if (list.size() == 1) {
            return this.segSentence(list.get(0));
        }
        if (!PARALLEL_SEG) {
            return list.stream().flatMap(string -> this.segSentence((String)string).stream()).collect(Collectors.toList());
        }
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            hashMap.put(i, list.get(i));
        }
        List[] listArray = new List[list.size()];
        hashMap.entrySet().parallelStream().forEach(entry -> {
            int n = (Integer)entry.getKey();
            String string = (String)entry.getValue();
            listArray[n] = this.segSentence(string);
        });
        list.clear();
        list = null;
        hashMap.clear();
        hashMap = null;
        ArrayList<Word> arrayList = new ArrayList<Word>();
        for (List list2 : listArray) {
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private List<Word> segSentence(String string) {
        if (string.length() == 1) {
            if (KEEP_WHITESPACE) {
                ArrayList<Word> arrayList = new ArrayList<Word>(1);
                arrayList.add(new Word(string));
                return arrayList;
            }
            if (!Character.isWhitespace(string.charAt(0))) {
                ArrayList<Word> arrayList = new ArrayList<Word>(1);
                arrayList.add(new Word(string));
                return arrayList;
            }
        }
        if (string.length() > 1) {
            List<Word> list = this.segImpl(string);
            if (list != null) {
                if (PERSON_NAME_RECOGNIZE) {
                    list = PersonName.recognize(list);
                }
                return list;
            }
            this.LOGGER.error("\u6587\u672c " + string + " \u6ca1\u6709\u83b7\u5f97\u5206\u8bcd\u7ed3\u679c");
        }
        return null;
    }

    protected void addWord(List<Word> list, String string, int n, int n2) {
        Word word = this.getWord(string, n, n2);
        if (word != null) {
            list.add(word);
        }
    }

    protected void addWord(Stack<Word> stack, String string, int n, int n2) {
        Word word = this.getWord(string, n, n2);
        if (word != null) {
            stack.push(word);
        }
    }

    protected Word getWord(String string, int n, int n2) {
        Word word = new Word(string.substring(n, n + n2).toLowerCase());
        if (KEEP_WHITESPACE) {
            return word;
        }
        if (n2 > 1) {
            return word;
        }
        if (!Character.isWhitespace(string.charAt(n))) {
            return word;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        AbstractSegmentation abstractSegmentation = new AbstractSegmentation(){

            @Override
            public List<Word> segImpl(String string) {
                ArrayList<Word> arrayList = new ArrayList<Word>();
                for (String string2 : string.split("\\s+")) {
                    arrayList.add(new Word(string2));
                }
                return arrayList;
            }

            @Override
            public SegmentationAlgorithm getSegmentationAlgorithm() {
                return null;
            }
        };
        System.out.println(abstractSegmentation.seg("i love programming"));
    }
}

