/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.util.formating;

import java.lang.reflect.Array;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.TabularData;

public class JsonExporter {
    public static String mbean2json(Map<String, Object> attributes) {
        StringBuilder sb = new StringBuilder();
        JsonExporter.mbean2json(sb, attributes);
        return sb.toString();
    }

    public static void mbean2json(StringBuilder sb, Map<String, Object> attributes) {
        JsonExporter.writeStartObject(sb);
        for (Map.Entry<String, Object> attr : attributes.entrySet()) {
            JsonExporter.writeFieldName(sb, attr.getKey());
            JsonExporter.mbean2json(sb, attr.getValue());
        }
        JsonExporter.writeEndObject(sb);
    }

    private static void mbean2json(StringBuilder sb, Object value) {
        if (value == null) {
            JsonExporter.writeNull(sb);
        } else {
            Class<?> c = value.getClass();
            if (c.isArray()) {
                JsonExporter.writeStartArray(sb);
                int len = Array.getLength(value);
                for (int j = 0; j < len; ++j) {
                    Object item = Array.get(value, j);
                    if (j != 0) {
                        sb.append(", ");
                    }
                    JsonExporter.mbean2json(sb, item);
                }
                JsonExporter.writeEndArray(sb);
            } else if (value instanceof Number) {
                Number n = (Number)value;
                JsonExporter.writeNumber(sb, n.toString());
            } else if (value instanceof Boolean) {
                Boolean b = (Boolean)value;
                JsonExporter.writeBoolean(sb, b);
            } else if (value instanceof CompositeData) {
                CompositeData cds = (CompositeData)value;
                CompositeType comp = cds.getCompositeType();
                Set<String> keys = comp.keySet();
                JsonExporter.writeStartObject(sb);
                for (String key : keys) {
                    JsonExporter.writeFieldName(sb, key);
                    JsonExporter.mbean2json(sb, cds.get(key));
                }
                JsonExporter.writeEndObject(sb);
            } else if (value instanceof TabularData) {
                TabularData tds = (TabularData)value;
                JsonExporter.writeStartArray(sb);
                boolean first = true;
                for (Object entry : tds.values()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    JsonExporter.mbean2json(sb, entry);
                }
                JsonExporter.writeEndArray(sb);
            } else {
                JsonExporter.writeString(sb, value.toString());
            }
        }
    }

    private static void writeNull(StringBuilder sb) {
        sb.append("null");
    }

    private static void writeNumber(StringBuilder sb, String num) {
        sb.append(num);
    }

    private static void writeBoolean(StringBuilder sb, boolean b) {
        sb.append(b ? "true" : "false");
    }

    private static void writeStartArray(StringBuilder sb) {
        sb.append("[");
    }

    private static void writeEndArray(StringBuilder sb) {
        sb.append("]");
    }

    private static void writeStartObject(StringBuilder sb) {
        sb.append("{");
    }

    private static void writeEndObject(StringBuilder sb) {
        sb.append("}");
    }

    private static void writeFieldName(StringBuilder sb, String fieldName) {
        if (JsonExporter.isCommaNeeded(sb)) {
            sb.append(", ");
        }
        JsonExporter.writeString(sb, fieldName);
        sb.append(": ");
    }

    private static void writeString(StringBuilder sb, String fieldName) {
        sb.append("\"");
        for (int i = 0; i < fieldName.length(); ++i) {
            char c = fieldName.charAt(i);
            if (c == '\"') {
                sb.append("\\\"");
                continue;
            }
            if (c == '\n') {
                sb.append("\\n");
                continue;
            }
            if (c == '\r') {
                sb.append("\\r");
                continue;
            }
            if (c == '\t') {
                sb.append("\\t");
                continue;
            }
            sb.append(c);
        }
        sb.append("\"");
    }

    private static boolean isCommaNeeded(StringBuilder sb) {
        for (int c = sb.length() - 1; c >= 0; --c) {
            char lc = sb.charAt(c);
            if (Character.isWhitespace(lc)) {
                continue;
            }
            return lc != '{' && lc != '[';
        }
        return false;
    }
}

