/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.util;

import java.io.Serializable;

public class IStringBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private char[] buff;
    private int count;

    public IStringBuffer() {
        this(16);
    }

    public IStringBuffer(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length <= 0");
        }
        this.buff = new char[length];
        this.count = 0;
    }

    public IStringBuffer(String str) {
        this(str.length() + 16);
        this.append(str);
    }

    private void resizeTo(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length <= 0");
        }
        if (length != this.buff.length) {
            int len = length > this.buff.length ? this.buff.length : length;
            char[] obuff = this.buff;
            this.buff = new char[length];
            System.arraycopy(obuff, 0, this.buff, 0, len);
        }
    }

    public IStringBuffer append(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        if (this.count + str.length() > this.buff.length) {
            this.resizeTo((this.count + str.length()) * 2 + 1);
        }
        for (int j = 0; j < str.length(); ++j) {
            this.buff[this.count++] = str.charAt(j);
        }
        return this;
    }

    public IStringBuffer append(char[] chars, int start, int length) {
        if (chars == null) {
            throw new NullPointerException();
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (length <= 0) {
            throw new IndexOutOfBoundsException();
        }
        if (start + length > chars.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.count + length > this.buff.length) {
            this.resizeTo((this.count + length) * 2 + 1);
        }
        for (int j = 0; j < length; ++j) {
            this.buff[this.count++] = chars[start + j];
        }
        return this;
    }

    public IStringBuffer append(char[] chars, int start) {
        this.append(chars, start, chars.length - start);
        return this;
    }

    public IStringBuffer append(char[] chars) {
        return this.append(chars, 0, chars.length);
    }

    public IStringBuffer append(char c) {
        if (this.count == this.buff.length) {
            this.resizeTo(this.buff.length * 2 + 1);
        }
        this.buff[this.count++] = c;
        return this;
    }

    public IStringBuffer append(boolean bool) {
        String str = bool ? "true" : "false";
        return this.append(str);
    }

    public IStringBuffer append(short shortv) {
        return this.append(String.valueOf(shortv));
    }

    public IStringBuffer append(int intv) {
        return this.append(String.valueOf(intv));
    }

    public IStringBuffer append(long longv) {
        return this.append(String.valueOf(longv));
    }

    public IStringBuffer append(float floatv) {
        return this.append(String.valueOf(floatv));
    }

    public IStringBuffer append(double doublev) {
        return this.append(String.valueOf(doublev));
    }

    public int length() {
        return this.count;
    }

    public int setLength(int length) {
        int oldCount = this.count;
        this.count = length;
        return oldCount;
    }

    public char charAt(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("idx{" + idx + "} < 0");
        }
        if (idx >= this.count) {
            throw new IndexOutOfBoundsException("idx{" + idx + "} >= buffer.length");
        }
        return this.buff[idx];
    }

    public char last() {
        if (this.count == 0) {
            throw new IndexOutOfBoundsException("Empty buffer");
        }
        return this.buff[this.count - 1];
    }

    public char first() {
        if (this.count == 0) {
            throw new IndexOutOfBoundsException("Empty buffer");
        }
        return this.buff[0];
    }

    public IStringBuffer deleteCharAt(int idx) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("idx < 0");
        }
        if (idx >= this.count) {
            throw new IndexOutOfBoundsException("idx >= buffer.length");
        }
        for (int j = idx; j < this.count - 1; ++j) {
            this.buff[j] = this.buff[j + 1];
        }
        --this.count;
        return this;
    }

    public void set(int idx, char chr) {
        if (idx < 0) {
            throw new IndexOutOfBoundsException("idx < 0");
        }
        if (idx >= this.count) {
            throw new IndexOutOfBoundsException("idx >= buffer.length");
        }
        this.buff[idx] = chr;
    }

    public char[] buffer() {
        return this.buff;
    }

    public IStringBuffer clear() {
        this.count = 0;
        return this;
    }

    public String toString() {
        return new String(this.buff, 0, this.count);
    }
}

