/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.raft.compress;

import com.alipay.sofa.jraft.util.ExecutorServiceHelper;
import com.alipay.sofa.jraft.util.NamedThreadFactory;
import com.alipay.sofa.jraft.util.Requires;
import com.alipay.sofa.jraft.util.ThreadPoolUtil;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import org.apache.commons.compress.archivers.zip.ParallelScatterZipCreator;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.apache.commons.compress.parallel.InputStreamSupplier;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.apache.hugegraph.backend.store.raft.compress.CompressStrategy;
import org.apache.hugegraph.config.CoreOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelCompressStrategy
implements CompressStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(ParallelCompressStrategy.class);
    public static final int QUEUE_SIZE = CoreOptions.CPUS;
    public static final long KEEP_ALIVE_SECOND = 300L;
    private final int compressThreads;
    private final int decompressThreads;

    public ParallelCompressStrategy(int compressThreads, int decompressThreads) {
        this.compressThreads = compressThreads;
        this.decompressThreads = decompressThreads;
    }

    @Override
    public void compressZip(String rootDir, String sourceDir, String outputZipFile, Checksum checksum) throws Throwable {
        File rootFile = new File(Paths.get(rootDir, sourceDir).toString());
        File zipFile = new File(outputZipFile);
        LOG.info("Start to compress snapshot in parallel mode");
        FileUtils.forceMkdir((File)zipFile.getParentFile());
        ExecutorService compressExecutor = ParallelCompressStrategy.newFixedPool(this.compressThreads, this.compressThreads, "raft-snapshot-compress-executor", new ThreadPoolExecutor.CallerRunsPolicy());
        ZipArchiveScatterOutputStream scatterOutput = new ZipArchiveScatterOutputStream(compressExecutor);
        this.compressDirectoryToZipFile(rootFile, scatterOutput, sourceDir, 8);
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             CheckedOutputStream cos = new CheckedOutputStream(bos, checksum);
             ZipArchiveOutputStream archiveOutputStream = new ZipArchiveOutputStream((OutputStream)cos);){
            scatterOutput.writeTo(archiveOutputStream);
            archiveOutputStream.flush();
            fos.getFD().sync();
        }
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)compressExecutor);
    }

    @Override
    public void decompressZip(String sourceZipFile, String outputDir, Checksum checksum) throws Throwable {
        LOG.info("Start to decompress snapshot in parallel mode");
        ExecutorService decompressExecutor = ParallelCompressStrategy.newFixedPool(this.decompressThreads, this.decompressThreads, "raft-snapshot-decompress-executor", new ThreadPoolExecutor.CallerRunsPolicy());
        Future<Boolean> checksumFuture = decompressExecutor.submit(() -> {
            this.computeZipFileChecksumValue(sourceZipFile, checksum);
            return true;
        });
        try (ZipFile zipFile = new ZipFile(sourceZipFile);){
            ArrayList futures = Lists.newArrayList();
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipArchiveEntry zipEntry = (ZipArchiveEntry)e.nextElement();
                Future<Boolean> future = decompressExecutor.submit(() -> {
                    this.unZipFile(zipFile, zipEntry, outputDir);
                    return true;
                });
                futures.add(future);
            }
            for (Future future : futures) {
                future.get();
            }
        }
        checksumFuture.get();
        ExecutorServiceHelper.shutdownAndAwaitTermination((ExecutorService)decompressExecutor);
    }

    private void compressDirectoryToZipFile(File dir, ZipArchiveScatterOutputStream scatterOutput, String sourceDir, int method) {
        File[] files;
        if (dir == null) {
            return;
        }
        if (dir.isFile()) {
            this.addEntry(sourceDir, dir, scatterOutput, method);
            return;
        }
        for (File file : files = (File[])Requires.requireNonNull((Object)Objects.requireNonNull(dir.listFiles()), (String)"files")) {
            String child = Paths.get(sourceDir, file.getName()).toString();
            if (file.isDirectory()) {
                this.compressDirectoryToZipFile(file, scatterOutput, child, method);
                continue;
            }
            this.addEntry(child, file, scatterOutput, method);
        }
    }

    private void addEntry(String filePath, File file, ZipArchiveScatterOutputStream scatterOutputStream, int method) {
        ZipArchiveEntry archiveEntry = new ZipArchiveEntry(filePath);
        archiveEntry.setMethod(method);
        scatterOutputStream.addEntry(archiveEntry, () -> {
            try {
                return file.isDirectory() ? new NullInputStream(0L) : new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException e) {
                LOG.error("Can't find file, path={}, {}", (Object)file.getPath(), (Object)e);
                return new NullInputStream(0L);
            }
        });
    }

    private void unZipFile(ZipFile zipFile, ZipArchiveEntry entry, String targetDir) throws Exception {
        File targetFile = new File(Paths.get(targetDir, entry.getName()).toString());
        if (!targetFile.toPath().normalize().startsWith(targetDir)) {
            throw new IOException(String.format("Bad entry: %s", entry.getName()));
        }
        FileUtils.forceMkdir((File)targetFile.getParentFile());
        try (InputStream is = zipFile.getInputStream(entry);
             BufferedInputStream fis = new BufferedInputStream(is);
             BufferedOutputStream bos = new BufferedOutputStream(Files.newOutputStream(targetFile.toPath(), new OpenOption[0]));){
            IOUtils.copy((InputStream)fis, (OutputStream)bos);
        }
    }

    private void computeZipFileChecksumValue(String zipPath, Checksum checksum) throws Exception {
        try (BufferedInputStream bis = new BufferedInputStream(Files.newInputStream(Paths.get(zipPath, new String[0]), new OpenOption[0]));
             CheckedInputStream cis = new CheckedInputStream(bis, checksum);
             ZipArchiveInputStream zis = new ZipArchiveInputStream((InputStream)cis);){
            while (zis.getNextZipEntry() != null) {
            }
        }
    }

    private static ExecutorService newFixedPool(int coreThreads, int maxThreads, String name, RejectedExecutionHandler handler) {
        ArrayBlockingQueue queue = new ArrayBlockingQueue(QUEUE_SIZE);
        return ThreadPoolUtil.newBuilder().poolName(name).enableMetric(Boolean.valueOf(false)).coreThreads(Integer.valueOf(coreThreads)).maximumThreads(Integer.valueOf(maxThreads)).keepAliveSeconds(Long.valueOf(300L)).workQueue(queue).threadFactory((ThreadFactory)new NamedThreadFactory(name, true)).rejectedHandler(handler).build();
    }

    private static class ZipArchiveScatterOutputStream {
        private final ParallelScatterZipCreator creator;

        public ZipArchiveScatterOutputStream(ExecutorService executorService) {
            this.creator = new ParallelScatterZipCreator(executorService);
        }

        public void addEntry(ZipArchiveEntry entry, InputStreamSupplier supplier) {
            this.creator.addArchiveEntry(entry, supplier);
        }

        public void writeTo(ZipArchiveOutputStream archiveOutput) throws Exception {
            this.creator.writeTo(archiveOutput);
        }
    }
}

