/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.k8s;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hugegraph.config.OptionSpace;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class K8sDriverProxy {
    private static final Logger LOG = Log.logger(K8sDriverProxy.class);
    private static final String CONFIG_PATH_SUFFIX = "/.kube/config";
    private static final String USER_HOME = "user.home";
    private static final String USER_DIR = System.getProperty("user.dir");
    private static boolean K8S_API_ENABLED = false;
    private static String KUBE_CONFIG_PATH = "";
    private static String ENABLE_INTERNAL_ALGORITHM = "";
    private static String INTERNAL_ALGORITHM_IMAGE_URL = "";
    private static Map<String, String> ALGORITHM_PARAMS = null;
    private static String INTERNAL_ALGORITHM = "[]";
    protected final Map<String, String> options = new HashMap<String, String>();

    public K8sDriverProxy(String partitionsCount, String algorithm) {
        try {
            if (!K8S_API_ENABLED) {
                throw new UnsupportedOperationException("The k8s api not enabled.");
            }
            String paramsClass = ALGORITHM_PARAMS.get(algorithm);
            this.initConfig(partitionsCount, INTERNAL_ALGORITHM, paramsClass);
        }
        catch (Throwable throwable) {
            LOG.error("Failed to start K8sDriverProxy ", throwable);
        }
    }

    public static void disable() {
        K8S_API_ENABLED = false;
    }

    public static String getEnableInternalAlgorithm() {
        return ENABLE_INTERNAL_ALGORITHM;
    }

    public static String getInternalAlgorithmImageUrl() {
        return INTERNAL_ALGORITHM_IMAGE_URL;
    }

    public static String getInternalAlgorithm() {
        return INTERNAL_ALGORITHM;
    }

    public static Map<String, String> getAlgorithms() {
        return ALGORITHM_PARAMS;
    }

    public static void setConfig(String enableInternalAlgorithm, String internalAlgorithmImageUrl, String internalAlgorithm, Map<String, String> algorithms) throws IOException {
        String path = System.getProperty(USER_HOME) + CONFIG_PATH_SUFFIX;
        File kubeConfigFile = new File(path);
        if (!kubeConfigFile.exists()) {
            throw new IOException("[K8s API] k8s config fail");
        }
        K8S_API_ENABLED = true;
        KUBE_CONFIG_PATH = kubeConfigFile.getAbsolutePath();
        ENABLE_INTERNAL_ALGORITHM = enableInternalAlgorithm;
        INTERNAL_ALGORITHM_IMAGE_URL = internalAlgorithmImageUrl;
        ALGORITHM_PARAMS = algorithms;
        INTERNAL_ALGORITHM = internalAlgorithm;
    }

    public static boolean isK8sApiEnabled() {
        return K8S_API_ENABLED;
    }

    public static boolean isValidAlgorithm(String algorithm) {
        return ALGORITHM_PARAMS.containsKey(algorithm);
    }

    public static String getAlgorithmClass(String algorithm) {
        return ALGORITHM_PARAMS.get(algorithm);
    }

    protected void initConfig(String partitionsCount, String internalAlgorithm, String paramsClass) {
        this.options.put("k8s.kube_config", KUBE_CONFIG_PATH);
        this.options.put("k8s.enable_internal_algorithm", ENABLE_INTERNAL_ALGORITHM);
        this.options.put("k8s.internal_algorithm_image_url", INTERNAL_ALGORITHM_IMAGE_URL);
        this.options.put("job.partitions_count", partitionsCount);
        this.options.put("k8s.internal_algorithm", internalAlgorithm);
        this.options.put("algorithm.params_class", paramsClass);
    }

    static {
        OptionSpace.register((String)"computer-driver", (String)"org.apache.hugegraph.computer.driver.config.ComputerOptions");
        OptionSpace.register((String)"computer-k8s-driver", (String)"org.apache.hugegraph.computer.k8s.config.KubeDriverOptions");
        OptionSpace.register((String)"computer-k8s-spec", (String)"org.apache.hugegraph.computer.k8s.config.KubeSpecOptions");
    }
}

