/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.traversal.algorithm.records;

import java.util.List;
import java.util.Stack;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.structure.HugeEdge;
import org.apache.hugegraph.traversal.algorithm.HugeTraverser;
import org.apache.hugegraph.traversal.algorithm.records.SingleWayMultiPathsRecords;
import org.apache.hugegraph.traversal.algorithm.records.record.Record;
import org.apache.hugegraph.traversal.algorithm.records.record.RecordType;
import org.apache.hugegraph.type.define.CollectionType;
import org.apache.hugegraph.util.collection.CollectionFactory;
import org.apache.hugegraph.util.collection.IntIterator;

public class KoutRecords
extends SingleWayMultiPathsRecords {
    private final int depth;

    public KoutRecords(boolean concurrent, Id source, boolean nearest, int depth) {
        super(RecordType.INT, concurrent, source, nearest);
        this.depth = depth;
        for (int i = 0; i < depth; ++i) {
            this.records().push(this.newRecord());
        }
        assert (this.records().size() == depth + 1);
        this.currentRecord(this.records().peek(), null);
    }

    @Override
    public int size() {
        return this.currentRecord().size();
    }

    @Override
    public List<Id> ids(long limit) {
        List<Id> ids = CollectionFactory.newList(CollectionType.EC);
        IntIterator iterator = this.records().peek().keys();
        while ((limit == -1L || limit-- > 0L) && iterator.hasNext()) {
            ids.add(this.id(iterator.next()));
        }
        return ids;
    }

    @Override
    public HugeTraverser.PathSet paths(long limit) {
        HugeTraverser.PathSet paths = new HugeTraverser.PathSet();
        Stack<Record> records = this.records();
        IntIterator iterator = records.peek().keys();
        while ((limit == -1L || limit-- > 0L) && iterator.hasNext()) {
            paths.add(this.linkPath(records.size() - 1, iterator.next()));
        }
        return paths;
    }

    public void addFullPath(List<HugeEdge> edges) {
        assert (this.depth == edges.size());
        int sourceCode = this.code(edges.get(0).id().ownerVertexId());
        for (int i = 0; i < edges.size(); ++i) {
            HugeEdge edge = edges.get(i);
            Id sourceV = edge.id().ownerVertexId();
            Id targetV = edge.id().otherVertexId();
            assert (this.code(sourceV) == sourceCode);
            this.edgeResults().addEdge(sourceV, targetV, edge);
            int targetCode = this.code(targetV);
            Record record = (Record)this.records().elementAt(i + 1);
            if (this.sourceCode == targetCode) break;
            this.addPathToRecord(sourceCode, targetCode, record);
            sourceCode = targetCode;
        }
    }
}

