/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.utils;

import com.alibaba.nacos.common.utils.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public final class ThreadUtils {
    private static final int THREAD_MULTIPLER = 2;

    public static void objectWait(Object object) {
        try {
            object.wait();
        }
        catch (InterruptedException ignore) {
            Thread.interrupted();
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void countDown(CountDownLatch latch) {
        Objects.requireNonNull(latch, "latch");
        latch.countDown();
    }

    public static void latchAwait(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void latchAwait(CountDownLatch latch, long time, TimeUnit unit) {
        try {
            latch.await(time, unit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static int getSuitableThreadCount() {
        return ThreadUtils.getSuitableThreadCount(2);
    }

    public static int getSuitableThreadCount(int threadMultiple) {
        int workerCount;
        int coreCount = Runtime.getRuntime().availableProcessors();
        for (workerCount = 1; workerCount < coreCount * threadMultiple; workerCount <<= 1) {
        }
        return workerCount;
    }

    public static void shutdownThreadPool(ExecutorService executor) {
        ThreadUtils.shutdownThreadPool(executor, null);
    }

    public static void shutdownThreadPool(ExecutorService executor, Logger logger) {
        executor.shutdown();
        for (int retry = 3; retry > 0; --retry) {
            try {
                if (!executor.awaitTermination(1L, TimeUnit.SECONDS)) continue;
                return;
            }
            catch (InterruptedException e) {
                executor.shutdownNow();
                Thread.interrupted();
                continue;
            }
            catch (Throwable ex) {
                if (logger == null) continue;
                logger.error("ThreadPoolManager shutdown executor has error : {}", ex);
                continue;
            }
        }
        executor.shutdownNow();
    }

    public static void addShutdownHook(Runnable runnable) {
        Runtime.getRuntime().addShutdownHook(new Thread(runnable));
    }
}

