/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.config.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.QueryParams;
import com.ecwid.consul.v1.Response;
import com.ecwid.consul.v1.kv.model.GetValue;
import com.ecwid.consul.v1.kv.model.PutParams;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.seata.common.thread.NamedThreadFactory;
import org.apache.seata.common.util.CollectionUtils;
import org.apache.seata.common.util.NetUtil;
import org.apache.seata.common.util.StringUtils;
import org.apache.seata.config.AbstractConfiguration;
import org.apache.seata.config.ConfigFuture;
import org.apache.seata.config.Configuration;
import org.apache.seata.config.ConfigurationChangeEvent;
import org.apache.seata.config.ConfigurationChangeListener;
import org.apache.seata.config.ConfigurationFactory;
import org.apache.seata.config.processor.ConfigProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsulConfiguration
extends AbstractConfiguration {
    private static volatile ConsulConfiguration instance;
    private static volatile ConsulClient client;
    private static final Logger LOGGER;
    private static final Configuration FILE_CONFIG;
    private static final String SERVER_ADDR_KEY = "serverAddr";
    private static final String CONSUL_CONFIG_KEY = "key";
    private static final String CONFIG_TYPE = "consul";
    private static final String ACL_TOKEN = "aclToken";
    private static final String DEFAULT_CONSUL_CONFIG_KEY_VALUE = "seata.properties";
    private static final String FILE_CONFIG_KEY_PREFIX = "config.consul.";
    private static final int THREAD_POOL_NUM = 1;
    private static final int MAP_INITIAL_CAPACITY = 8;
    private ExecutorService consulNotifierExecutor = new ThreadPoolExecutor(1, 1, Integer.MAX_VALUE, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("consul-config-executor", 1));
    private static final ConcurrentMap<String, Set<ConfigurationChangeListener>> CONFIG_LISTENERS_MAP;
    private static volatile Properties seataConfig;
    private static final int DEFAULT_WATCH_TIMEOUT = 60;
    private static final long CAS = 0L;

    private ConsulConfiguration() {
        this.initSeataConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConsulConfiguration getInstance() {
        if (instance != null) return instance;
        Class<ConsulConfiguration> clazz = ConsulConfiguration.class;
        synchronized (ConsulConfiguration.class) {
            if (instance != null) return instance;
            instance = new ConsulConfiguration();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public String getLatestConfig(String dataId, String defaultValue, long timeoutMills) {
        String value = seataConfig.getProperty(dataId);
        if (value == null) {
            ConfigFuture configFuture = new ConfigFuture(dataId, defaultValue, ConfigFuture.ConfigOperation.GET, timeoutMills);
            this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().getKVValue(dataId, ConsulConfiguration.getAclToken()), configFuture));
            value = (String)configFuture.get();
        }
        return value;
    }

    public boolean putConfig(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUT, timeoutMills);
        if (!seataConfig.isEmpty()) {
            seataConfig.put(dataId, content);
            this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().setKVValue(ConsulConfiguration.getConsulConfigKey(), ConsulConfiguration.getSeataConfigStr(), ConsulConfiguration.getAclToken(), null), configFuture));
        } else {
            this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().setKVValue(dataId, content, ConsulConfiguration.getAclToken(), null), configFuture));
        }
        return (Boolean)configFuture.get();
    }

    public boolean putConfigIfAbsent(String dataId, String content, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, content, ConfigFuture.ConfigOperation.PUTIFABSENT, timeoutMills);
        if (!seataConfig.isEmpty()) {
            String property = seataConfig.getProperty(dataId);
            if (null == property) {
                seataConfig.put(dataId, content);
                PutParams putParams = new PutParams();
                putParams.setCas(Long.valueOf(0L));
                this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().setKVValue(ConsulConfiguration.getConsulConfigKey(), ConsulConfiguration.getSeataConfigStr(), ConsulConfiguration.getAclToken(), putParams), configFuture));
            }
        } else {
            this.consulNotifierExecutor.execute(() -> {
                PutParams putParams = new PutParams();
                putParams.setCas(Long.valueOf(0L));
                this.complete(ConsulConfiguration.getConsulClient().setKVValue(dataId, content, ConsulConfiguration.getAclToken(), putParams), configFuture);
            });
        }
        return (Boolean)configFuture.get();
    }

    public boolean removeConfig(String dataId, long timeoutMills) {
        ConfigFuture configFuture = new ConfigFuture(dataId, null, ConfigFuture.ConfigOperation.REMOVE, timeoutMills);
        if (!seataConfig.isEmpty()) {
            seataConfig.remove(dataId);
            this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().setKVValue(ConsulConfiguration.getConsulConfigKey(), ConsulConfiguration.getSeataConfigStr(), ConsulConfiguration.getAclToken(), null), configFuture));
        } else {
            this.consulNotifierExecutor.execute(() -> this.complete(ConsulConfiguration.getConsulClient().deleteKVValue(dataId, ConsulConfiguration.getAclToken()), configFuture));
        }
        return (Boolean)configFuture.get();
    }

    public void addConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        ConsulListener consulListener = new ConsulListener(dataId, listener);
        CONFIG_LISTENERS_MAP.computeIfAbsent(dataId, key -> ConcurrentHashMap.newKeySet()).add(consulListener);
        consulListener.onProcessEvent(new ConfigurationChangeEvent());
    }

    public void removeConfigListener(String dataId, ConfigurationChangeListener listener) {
        if (StringUtils.isBlank((String)dataId) || listener == null) {
            return;
        }
        Set<ConfigurationChangeListener> configListeners = this.getConfigListeners(dataId);
        if (CollectionUtils.isNotEmpty(configListeners)) {
            for (ConfigurationChangeListener entry : configListeners) {
                ConfigurationChangeListener target = ((ConsulListener)entry).getTargetListener();
                if (!listener.equals((Object)target)) continue;
                entry.onShutDown();
                configListeners.remove(entry);
                break;
            }
        }
    }

    public Set<ConfigurationChangeListener> getConfigListeners(String dataId) {
        return (Set)CONFIG_LISTENERS_MAP.get(dataId);
    }

    public String getTypeName() {
        return CONFIG_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ConsulClient getConsulClient() {
        if (client != null) return client;
        Class<ConsulConfiguration> clazz = ConsulConfiguration.class;
        synchronized (ConsulConfiguration.class) {
            if (client != null) return client;
            String serverAddr = FILE_CONFIG.getConfig("config.consul.serverAddr");
            InetSocketAddress inetSocketAddress = NetUtil.toInetSocketAddress((String)serverAddr);
            client = new ConsulClient(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    private static String getAclToken() {
        String aclToken = StringUtils.isNotBlank((String)System.getProperty(ACL_TOKEN)) ? System.getProperty(ACL_TOKEN) : FILE_CONFIG.getConfig("config.consul.aclToken");
        return StringUtils.isNotBlank((String)aclToken) ? aclToken : null;
    }

    private void complete(Response response, ConfigFuture configFuture) {
        if (response != null && response.getValue() != null) {
            Object value = response.getValue();
            if (value instanceof GetValue) {
                configFuture.setResult((Object)((GetValue)value).getDecodedValue());
            } else {
                configFuture.setResult(value);
            }
        }
    }

    private void initSeataConfig() {
        String key = ConsulConfiguration.getConsulConfigKey();
        Response kvValue = ConsulConfiguration.getConsulClient().getKVValue(key, ConsulConfiguration.getAclToken());
        String config = ((GetValue)kvValue.getValue()).getDecodedValue();
        if (StringUtils.isNotBlank((String)config)) {
            try {
                seataConfig = ConfigProcessor.processConfig((String)config, (String)ConsulConfiguration.getConsulDataType());
            }
            catch (IOException e) {
                LOGGER.error("init config properties error", (Throwable)e);
            }
        }
        ConsulListener consulListener = new ConsulListener(ConsulConfiguration.getConsulConfigKey(), null);
        consulListener.onProcessEvent(new ConfigurationChangeEvent());
    }

    private static String getConsulDataType() {
        return ConfigProcessor.resolverConfigDataType((String)ConsulConfiguration.getConsulConfigKey());
    }

    private static String getConsulConfigKey() {
        return FILE_CONFIG.getConfig("config.consul.key", DEFAULT_CONSUL_CONFIG_KEY_VALUE);
    }

    private static String getSeataConfigStr() {
        StringBuilder sb = new StringBuilder();
        Enumeration<?> enumeration = seataConfig.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String property = seataConfig.getProperty(key);
            sb.append(key).append("=").append(property).append("\n");
        }
        return sb.toString();
    }

    static {
        LOGGER = LoggerFactory.getLogger(ConsulConfiguration.class);
        FILE_CONFIG = ConfigurationFactory.CURRENT_FILE_INSTANCE;
        CONFIG_LISTENERS_MAP = new ConcurrentHashMap<String, Set<ConfigurationChangeListener>>(8);
        seataConfig = new Properties();
    }

    public static class ConsulListener
    implements ConfigurationChangeListener {
        private final ConfigurationChangeListener listener;
        private final String dataId;
        private long consulIndex;
        private final ExecutorService executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new NamedThreadFactory("consulListener", 1));

        public ConsulListener(String dataId, ConfigurationChangeListener listener) {
            this.dataId = dataId;
            this.listener = listener;
            this.consulIndex = ConsulConfiguration.getConsulClient().getKVValue(dataId, ConsulConfiguration.getAclToken()).getConsulIndex();
        }

        public void onChangeEvent(ConfigurationChangeEvent event) {
            while (true) {
                QueryParams queryParams = new QueryParams(60L, this.consulIndex);
                Response response = ConsulConfiguration.getConsulClient().getKVValue(this.dataId, ConsulConfiguration.getAclToken(), queryParams);
                Long currentIndex = response.getConsulIndex();
                if (currentIndex == null || currentIndex <= this.consulIndex) continue;
                String value = ((GetValue)response.getValue()).getDecodedValue();
                this.consulIndex = currentIndex;
                if (this.dataId.equals(ConsulConfiguration.getConsulConfigKey())) {
                    Properties seataConfigNew;
                    if (StringUtils.isBlank((String)value)) {
                        LOGGER.warn("Empty config from Consul, dataId='{}'. Skipped.", (Object)this.dataId);
                        continue;
                    }
                    try {
                        seataConfigNew = ConfigProcessor.processConfig((String)value, (String)ConsulConfiguration.getConsulDataType());
                    }
                    catch (IOException e) {
                        LOGGER.error("load config properties error", (Throwable)e);
                        continue;
                    }
                    for (Map.Entry entry : CONFIG_LISTENERS_MAP.entrySet()) {
                        String valueNew;
                        String key = (String)entry.getKey();
                        String valueOld = seataConfig.getProperty(key, "");
                        if (valueOld.equals(valueNew = seataConfigNew.getProperty(key, ""))) continue;
                        for (ConfigurationChangeListener changeListener : (Set)entry.getValue()) {
                            event.setDataId(key).setNewValue(valueNew);
                            ConfigurationChangeListener listener = ((ConsulListener)changeListener).getTargetListener();
                            listener.onProcessEvent(event);
                        }
                    }
                    seataConfig = seataConfigNew;
                    continue;
                }
                event.setDataId(this.dataId).setNewValue(value);
                this.listener.onProcessEvent(event);
            }
        }

        public ExecutorService getExecutorService() {
            return this.executor;
        }

        public ConfigurationChangeListener getTargetListener() {
            return this.listener;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConsulListener that = (ConsulListener)o;
            return this.consulIndex == that.consulIndex && Objects.equals(this.listener, that.listener) && Objects.equals(this.dataId, that.dataId) && Objects.equals(this.executor, that.executor);
        }

        public int hashCode() {
            return Objects.hash(this.listener, this.dataId, this.consulIndex, this.executor);
        }
    }
}

