/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.common.util;

import java.time.Clock;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class Backoff {
    public static final long DEFAULT_INTERVAL_IN_NANOSECONDS = TimeUnit.MILLISECONDS.toNanos(100L);
    public static final long MAX_BACKOFF_INTERVAL_NANOSECONDS = TimeUnit.SECONDS.toNanos(30L);
    private final long initial;
    private final long max;
    private final Clock clock;
    private long next;
    private long mandatoryStop;
    private long firstBackoffTimeInMillis;
    private boolean mandatoryStopMade = false;
    private static final Random random = new Random();

    Backoff(long initial, TimeUnit unitInitial, long max, TimeUnit unitMax, long mandatoryStop, TimeUnit unitMandatoryStop, Clock clock) {
        this.initial = unitInitial.toMillis(initial);
        this.max = unitMax.toMillis(max);
        if (initial == 0L && max == 0L && mandatoryStop == 0L) {
            this.mandatoryStopMade = true;
        }
        this.next = this.initial;
        this.mandatoryStop = unitMandatoryStop.toMillis(mandatoryStop);
        this.clock = clock;
        this.firstBackoffTimeInMillis = 0L;
    }

    public Backoff(long initial, TimeUnit unitInitial, long max, TimeUnit unitMax, long mandatoryStop, TimeUnit unitMandatoryStop) {
        this(initial, unitInitial, max, unitMax, mandatoryStop, unitMandatoryStop, Clock.systemDefaultZone());
    }

    public long next() {
        long current = this.next;
        if (current < this.max) {
            this.next = Math.min(this.next * 2L, this.max);
        }
        if (!this.mandatoryStopMade) {
            long now = this.clock.millis();
            long timeElapsedSinceFirstBackoff = 0L;
            if (this.initial == current) {
                this.firstBackoffTimeInMillis = now;
            } else {
                timeElapsedSinceFirstBackoff = now - this.firstBackoffTimeInMillis;
            }
            if (timeElapsedSinceFirstBackoff + current > this.mandatoryStop) {
                current = Math.max(this.initial, this.mandatoryStop - timeElapsedSinceFirstBackoff);
                this.mandatoryStopMade = true;
            }
        }
        if (current > 10L) {
            current -= (long)random.nextInt((int)current / 10);
        }
        return Math.max(this.initial, current);
    }

    public void reduceToHalf() {
        if (this.next > this.initial) {
            this.next = Math.max(this.next / 2L, this.initial);
        }
    }

    public void reset() {
        this.next = this.initial;
        this.mandatoryStopMade = this.initial == 0L && this.max == 0L && this.mandatoryStop == 0L;
    }

    public static boolean shouldBackoff(long initialTimestamp, TimeUnit unitInitial, int failedAttempts, long defaultInterval, long maxBackoffInterval) {
        long initialTimestampInNano = unitInitial.toNanos(initialTimestamp);
        long currentTime = System.nanoTime();
        long interval = defaultInterval;
        for (int i = 1; i < failedAttempts; ++i) {
            if ((interval *= 2L) <= maxBackoffInterval) continue;
            interval = maxBackoffInterval;
            break;
        }
        return currentTime < initialTimestampInNano + interval;
    }

    public static boolean shouldBackoff(long initialTimestamp, TimeUnit unitInitial, int failedAttempts) {
        return Backoff.shouldBackoff(initialTimestamp, unitInitial, failedAttempts, DEFAULT_INTERVAL_IN_NANOSECONDS, MAX_BACKOFF_INTERVAL_NANOSECONDS);
    }

    @Generated
    public long getInitial() {
        return this.initial;
    }

    @Generated
    public long getMax() {
        return this.max;
    }

    @Generated
    public Clock getClock() {
        return this.clock;
    }

    @Generated
    public long getNext() {
        return this.next;
    }

    @Generated
    public long getMandatoryStop() {
        return this.mandatoryStop;
    }

    @Generated
    public long getFirstBackoffTimeInMillis() {
        return this.firstBackoffTimeInMillis;
    }

    @Generated
    public boolean isMandatoryStopMade() {
        return this.mandatoryStopMade;
    }

    @Generated
    public void setNext(long next) {
        this.next = next;
    }

    @Generated
    public void setMandatoryStop(long mandatoryStop) {
        this.mandatoryStop = mandatoryStop;
    }

    @Generated
    public void setFirstBackoffTimeInMillis(long firstBackoffTimeInMillis) {
        this.firstBackoffTimeInMillis = firstBackoffTimeInMillis;
    }

    @Generated
    public void setMandatoryStopMade(boolean mandatoryStopMade) {
        this.mandatoryStopMade = mandatoryStopMade;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Backoff)) {
            return false;
        }
        Backoff other = (Backoff)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getInitial() != other.getInitial()) {
            return false;
        }
        if (this.getMax() != other.getMax()) {
            return false;
        }
        if (this.getNext() != other.getNext()) {
            return false;
        }
        if (this.getMandatoryStop() != other.getMandatoryStop()) {
            return false;
        }
        if (this.getFirstBackoffTimeInMillis() != other.getFirstBackoffTimeInMillis()) {
            return false;
        }
        if (this.isMandatoryStopMade() != other.isMandatoryStopMade()) {
            return false;
        }
        Clock this$clock = this.getClock();
        Clock other$clock = other.getClock();
        return !(this$clock == null ? other$clock != null : !((Object)this$clock).equals(other$clock));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Backoff;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $initial = this.getInitial();
        result = result * 59 + (int)($initial >>> 32 ^ $initial);
        long $max = this.getMax();
        result = result * 59 + (int)($max >>> 32 ^ $max);
        long $next = this.getNext();
        result = result * 59 + (int)($next >>> 32 ^ $next);
        long $mandatoryStop = this.getMandatoryStop();
        result = result * 59 + (int)($mandatoryStop >>> 32 ^ $mandatoryStop);
        long $firstBackoffTimeInMillis = this.getFirstBackoffTimeInMillis();
        result = result * 59 + (int)($firstBackoffTimeInMillis >>> 32 ^ $firstBackoffTimeInMillis);
        result = result * 59 + (this.isMandatoryStopMade() ? 79 : 97);
        Clock $clock = this.getClock();
        result = result * 59 + ($clock == null ? 43 : ((Object)$clock).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Backoff(initial=" + this.getInitial() + ", max=" + this.getMax() + ", clock=" + this.getClock() + ", next=" + this.getNext() + ", mandatoryStop=" + this.getMandatoryStop() + ", firstBackoffTimeInMillis=" + this.getFirstBackoffTimeInMillis() + ", mandatoryStopMade=" + this.isMandatoryStopMade() + ")";
    }
}

