/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapAdapter;
import org.apache.jena.riot.system.PrefixMapZero;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.graph.PrefixMappingAdapter;
import org.apache.jena.util.XML11Char;

public class Prefixes {
    public static final String dftGraphPrefixSet = "http://jena.apache.org/ARQ#dftGraphPrefixSet";
    public static final String datasetPrefixSet = "";
    public static Node nodeDefaultGraph = NodeFactory.createURI((String)"http://jena.apache.org/ARQ#dftGraphPrefixSet");
    public static Node nodeDataset = NodeFactory.createURI((String)"");
    private static final String dftUri1 = Quad.defaultGraphIRI.getURI();
    private static final String dftUri2 = Quad.defaultGraphNodeGenerated.getURI();

    public static String prefix(String prefix) {
        if (prefix == null) {
            return datasetPrefixSet;
        }
        if (prefix.endsWith(":")) {
            return prefix.substring(prefix.length() - 1);
        }
        return prefix;
    }

    public static boolean isLegalPrefix(String prefix) {
        Objects.requireNonNull(prefix, "Prefix argument is null");
        if (prefix.isEmpty()) {
            return true;
        }
        String prefixStr = prefix;
        if (prefix.endsWith(":")) {
            prefixStr = prefix.substring(prefix.length() - 1);
        }
        return XML11Char.isXML11ValidNCName((String)prefixStr);
    }

    public static String findByURI(PrefixMap pmap, String uriStr) {
        return pmap.getMapping().entrySet().stream().filter(e2 -> Objects.equals(uriStr, ((String)e2.getValue()).toString())).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public static PrefixMap adapt(Graph graph) {
        Objects.requireNonNull(graph);
        return Prefixes.adapt(graph.getPrefixMapping());
    }

    public static PrefixMapping adapt(PrefixMap prefixMap) {
        Objects.requireNonNull(prefixMap);
        if (prefixMap instanceof PrefixMapAdapter) {
            PrefixMapAdapter prefixMapAdapter = (PrefixMapAdapter)prefixMap;
            return prefixMapAdapter.getPrefixMapping();
        }
        return new PrefixMappingAdapter(prefixMap);
    }

    public static PrefixMap adapt(PrefixMapping prefixMapping) {
        Objects.requireNonNull(prefixMapping);
        if (prefixMapping instanceof PrefixMappingAdapter) {
            return ((PrefixMappingAdapter)prefixMapping).getPrefixMap();
        }
        return new PrefixMapAdapter(prefixMapping);
    }

    public static String toString(PrefixMap prefixMap) {
        if (prefixMap.isEmpty()) {
            return "{}";
        }
        StringJoiner sj = new StringJoiner("\n", "{\n", "\n}");
        prefixMap.getMapping().forEach((p, u) -> sj.add(String.format("  %-8s <%s>", p + ":", u)));
        return sj.toString();
    }

    public static PrefixMap emptyPrefixMap() {
        return PrefixMapZero.empty;
    }
}

