/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.io;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.io.InputStreamBuffered;

public final class PeekInputStream
extends InputStream {
    private final InputStreamBuffered source;
    private static final int PUSHBACK_SIZE = 10;
    static final byte BYTE0 = 0;
    private byte[] pushbackBytes;
    private int idxPushback;
    private int currByte = -2;
    private long posn;
    public static final int INIT_LINE = 1;
    public static final int INIT_COL = 1;
    private long colNum;
    private long lineNum;

    public static PeekInputStream make(InputStream inputStream) {
        return PeekInputStream.make(inputStream, InputStreamBuffered.DFT_BUFSIZE);
    }

    public static PeekInputStream make(InputStream inputStream, int bufferSize) {
        if (inputStream instanceof PeekInputStream) {
            PeekInputStream peekInputStream = (PeekInputStream)inputStream;
            return peekInputStream;
        }
        if (inputStream instanceof InputStreamBuffered) {
            InputStreamBuffered bufferedInputStream = (InputStreamBuffered)inputStream;
            return new PeekInputStream(bufferedInputStream);
        }
        InputStreamBuffered in = new InputStreamBuffered(inputStream, bufferSize);
        return new PeekInputStream(in);
    }

    public static PeekInputStream open(String filename) {
        try {
            FileInputStream in = new FileInputStream(filename);
            return PeekInputStream.make(in);
        }
        catch (FileNotFoundException ex) {
            throw new AtlasException("File not found: " + filename);
        }
    }

    private PeekInputStream(InputStreamBuffered input) {
        this.source = input;
        this.pushbackBytes = new byte[10];
        this.idxPushback = -1;
        this.colNum = 1L;
        this.lineNum = 1L;
        this.posn = 0L;
    }

    public final InputStreamBuffered getInput() {
        return this.source;
    }

    public long getLineNum() {
        return this.lineNum;
    }

    public long getColNum() {
        return this.colNum;
    }

    public long getPosition() {
        return this.posn;
    }

    public final int peekByte() {
        if (this.idxPushback >= 0) {
            return this.pushbackBytes[this.idxPushback];
        }
        if (this.currByte == -2) {
            this.init();
        }
        return this.currByte;
    }

    private final void setCurrByte(int b) {
        this.currByte = b;
    }

    public final int readByte() {
        return this.nextByte();
    }

    public final void pushbackByte(int b) {
        this.unreadByte(b);
    }

    @Override
    public final void close() throws IOException {
        this.source.close();
    }

    @Override
    public final int read() throws IOException {
        if (this.eof()) {
            return -1;
        }
        int x = this.readByte();
        return x;
    }

    @Override
    public final int read(byte[] buf, int off, int len) throws IOException {
        if (this.eof()) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int ch = this.readByte();
            if (ch == -1) {
                return i == 0 ? -1 : i;
            }
            buf[i + off] = (byte)ch;
        }
        return len;
    }

    public final boolean eof() {
        return this.peekByte() == -1;
    }

    private final void unreadByte(int b) {
        if (this.idxPushback >= this.pushbackBytes.length) {
            byte[] pushbackBytes2 = new byte[this.pushbackBytes.length * 2];
            System.arraycopy(this.pushbackBytes, 0, pushbackBytes2, 0, this.pushbackBytes.length);
            this.pushbackBytes = pushbackBytes2;
        }
        if (b == -1 || b == -2) {
            IO.exception("Illegal byte to push back: " + b);
        }
        ++this.idxPushback;
        this.pushbackBytes[this.idxPushback] = (byte)b;
    }

    private final void init() {
        this.advanceAndSet();
        if (this.currByte == -2) {
            this.setCurrByte(-1);
        }
    }

    private final void advanceAndSet() {
        try {
            int ch = this.source.read();
            this.setCurrByte(ch);
        }
        catch (IOException ex) {
            IO.exception(ex);
        }
    }

    private final int nextByte() {
        int b = this.peekByte();
        if (b == -1) {
            return -1;
        }
        if (this.idxPushback >= 0) {
            byte b2 = this.pushbackBytes[this.idxPushback];
            --this.idxPushback;
            return b2;
        }
        ++this.posn;
        if (b == 10) {
            ++this.lineNum;
            this.colNum = 1L;
        } else {
            ++this.colNum;
        }
        this.advanceAndSet();
        return b;
    }
}

