/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.geosparql.spatial;

import org.apache.jena.geosparql.implementation.WKTLiteralFactory;
import org.apache.jena.geosparql.spatial.ConvertLatLon;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.sparql.expr.NodeValue;

public class ConvertLatLonBox {
    public static final String toWKT(double latMin, double lonMin, double latMax, double lonMax) {
        Literal wktBox = ConvertLatLonBox.toLiteral(latMin, lonMin, latMax, lonMax);
        return wktBox.getLexicalForm();
    }

    public static final Literal toLiteral(double latMin, double lonMin, double latMax, double lonMax) {
        ConvertLatLon.checkBounds(latMin, lonMin);
        ConvertLatLon.checkBounds(latMax, lonMax);
        return WKTLiteralFactory.createBox(latMin, lonMin, latMax, lonMax, "http://www.opengis.net/def/crs/EPSG/0/4326");
    }

    public static final NodeValue toNodeValue(NodeValue v1, NodeValue v2, NodeValue v3, NodeValue v4) {
        double latMin = ConvertLatLon.extractDouble(v1);
        double lonMin = ConvertLatLon.extractDouble(v2);
        double latMax = ConvertLatLon.extractDouble(v3);
        double lonMax = ConvertLatLon.extractDouble(v4);
        Literal wktBox = ConvertLatLonBox.toLiteral(latMin, lonMin, latMax, lonMax);
        return NodeValue.makeNode(wktBox.asNode());
    }

    public static final Node toNode(Node n1, Node n2, Node n3, Node n4) {
        NodeValue result = ConvertLatLonBox.toNodeValue(NodeValue.makeNode(n1), NodeValue.makeNode(n2), NodeValue.makeNode(n3), NodeValue.makeNode(n4));
        return result.asNode();
    }
}

