/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mod.shiro;

import jakarta.servlet.ServletException;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.apache.jena.atlas.io.IOX;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.fuseki.FusekiConfigException;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.main.FusekiServer;
import org.apache.jena.fuseki.main.runner.ServerArgs;
import org.apache.jena.fuseki.main.sys.FusekiModule;
import org.apache.jena.fuseki.mod.shiro.FusekiShiro;
import org.apache.jena.rdf.model.Model;
import org.apache.shiro.lang.io.ResourceUtils;
import org.apache.shiro.web.servlet.ShiroFilter;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.SessionHandler;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;

public class FMod_Shiro
implements FusekiModule {
    public static final Logger shiroConfigLog = FusekiShiro.shiroLog;
    private static List<String> iniFileLocations = null;
    private static ArgDecl argShiroIni = new ArgDecl(true, "shiro", "shiro-ini");
    public static String adminShiroFile = "org.apache.jena.fuseki:AdminShiroFile";
    private String argShiroFile = null;

    @Override
    public String name() {
        return "FMod Shiro";
    }

    public static FMod_Shiro create() {
        return new FMod_Shiro();
    }

    @Override
    public void serverArgsModify(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
        fusekiCmd.add(argShiroIni);
        this.argShiroFile = null;
    }

    @Override
    public void serverArgsPrepare(CmdGeneral fusekiCmd, ServerArgs serverArgs) {
        if (fusekiCmd.contains(argShiroIni)) {
            this.argShiroFile = fusekiCmd.getValue(argShiroIni);
            Path path = Path.of(this.argShiroFile, new String[0]);
            IOX.checkReadableFile(path, msg -> {
                FmtLog.error(shiroConfigLog, msg, new Object[0]);
                return new CmdException();
            });
        }
    }

    private String decideShiroConfiguration(FusekiServer.Builder serverBuilder) {
        String shiroConfig = this.argShiroFile;
        if (shiroConfig != null) {
            return shiroConfig;
        }
        shiroConfig = Lib.getenv("FUSEKI_SHIRO");
        if (shiroConfig != null) {
            return shiroConfig;
        }
        Object obj = serverBuilder.getServletAttribute(adminShiroFile);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Path) {
            Path path = (Path)obj;
            return path.toString();
        }
        FmtLog.error(shiroConfigLog, "Servlet attribute '%s' is not a Path: got: %s", adminShiroFile, obj);
        return null;
    }

    @Override
    public void prepare(FusekiServer.Builder serverBuilder, Set<String> datasetNames, Model configModel) {
        String shiroConfig = this.decideShiroConfiguration(serverBuilder);
        if (shiroConfig == null) {
            return;
        }
        String shiroResourceName = FusekiShiro.withResourcePrefix(shiroConfig);
        if (!ResourceUtils.resourceExists(shiroResourceName)) {
            throw new FusekiConfigException("Shiro resource does not exist");
        }
        FusekiShiroFilter filter = new FusekiShiroFilter(shiroResourceName);
        serverBuilder.addFilter("/*", filter);
        serverBuilder.setServletAttribute("org.apache.jena.fuseki:ShiroResource", shiroResourceName);
        this.argShiroFile = null;
    }

    @Override
    public void serverBeforeStarting(FusekiServer server) {
        try {
            String x = (String)server.getServletContext().getAttribute("org.apache.jena.fuseki:ShiroResource");
            if (x != null) {
                FmtLog.info(shiroConfigLog, "Shiro configuration: %s", x);
            }
        }
        catch (ClassCastException ex) {
            FmtLog.warn(shiroConfigLog, "Unexpected Shiro configuration: %s", server.getServletContext().getAttribute("org.apache.jena.fuseki:ShiroResource"));
        }
        Server jettyServer = server.getJettyServer();
        try {
            ServletContextHandler servletContextHandler = (ServletContextHandler)jettyServer.getHandler();
            if (servletContextHandler.getSessionHandler() == null) {
                SessionHandler sessionsHandler = new SessionHandler();
                servletContextHandler.setHandler(sessionsHandler);
            }
        }
        catch (RuntimeException ex) {
            shiroConfigLog.error("Failed to set a session manager - server aborted");
            throw ex;
        }
    }

    private static class FusekiShiroFilter
    extends ShiroFilter {
        private final String shiroInitializationResource;

        FusekiShiroFilter(String shiroResourceName) {
            this.shiroInitializationResource = shiroResourceName;
        }

        @Override
        public void init() throws Exception {
            try {
                List<String> locations = List.of();
                if (this.shiroInitializationResource != null) {
                    locations = List.of(this.shiroInitializationResource);
                }
                FusekiShiro.shiroEnvironment(this.getServletContext(), locations);
            }
            catch (FusekiException ex) {
                throw new ServletException(ex);
            }
            super.init();
        }
    }
}

