/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.engine.PlanBase;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCloseable;
import org.apache.jena.sparql.serializer.SerializationContext;

public class PlanOp
extends PlanBase {
    private QueryIterator qIter;
    private String label = null;

    public PlanOp(Op op, Closeable closeable, QueryIterator qIter) {
        super(op, closeable);
        this.qIter = new QueryIteratorCloseable(qIter, this);
    }

    public PlanOp(String label, Closeable closeable, Op op, QueryIterator qIter) {
        this(op, closeable, qIter);
        this.label = label;
    }

    @Override
    protected QueryIterator iteratorOnce() {
        return this.qIter;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
        if (this.getOp() == null) {
            out.println(Lib.className(this));
            return;
        }
        String str2 = this.label;
        if (this.label == null) {
            str2 = "Plan";
        }
        out.print("(");
        out.println(str2);
        out.incIndent();
        this.qIter.output(out, sCxt);
        out.print(")");
        out.decIndent();
        out.ensureStartOfLine();
    }
}

