/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.annotation;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import org.apache.juneau.AnnotationApplier;
import org.apache.juneau.BeanContext;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.commons.annotation.AppliedAnnotationObject;
import org.apache.juneau.commons.annotation.AppliedOnClassAnnotationObject;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.FieldInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Query;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.svl.VarResolverSession;

public class QueryAnnotation {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    public static final Query DEFAULT = QueryAnnotation.create().build();

    public static Builder create() {
        return new Builder();
    }

    public static Builder create(Class<?> ... on) {
        return QueryAnnotation.create().on(on);
    }

    public static Builder create(String ... on) {
        return QueryAnnotation.create().on(on);
    }

    public static boolean empty(Query a) {
        return a == null || DEFAULT.equals(a);
    }

    public static Optional<String> findDef(ParameterInfo pi) {
        return AP.find(Query.class, pi, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).filter(x -> Utils.ne((CharSequence)x.def())).findFirst().map(x -> x.def());
    }

    public static Optional<String> findName(ParameterInfo pi) {
        return AP.find(Query.class, pi, new AnnotationTraversal[0]).stream().map(AnnotationInfo::inner).filter(x -> StringUtils.isAnyNotBlank((CharSequence[])new CharSequence[]{x.value(), x.name()})).findFirst().map(x -> StringUtils.firstNonBlank((String[])new String[]{x.name(), x.value()}));
    }

    public static class Builder
    extends AppliedAnnotationObject.BuilderTMF {
        private String[] description = new String[0];
        private Class<? extends HttpPartParser> parser = HttpPartParser.Void.class;
        private Class<? extends HttpPartSerializer> serializer = HttpPartSerializer.Void.class;
        private Schema schema = SchemaAnnotation.DEFAULT;
        private String name = "";
        private String value = "";
        private String def = "";

        protected Builder() {
            super(Query.class);
        }

        public Query build() {
            return new Object(this);
        }

        public Builder description(String ... value) {
            this.description = value;
            return this;
        }

        public Builder def(String value) {
            this.def = value;
            return this;
        }

        public Builder name(String value) {
            this.name = value;
            return this;
        }

        public Builder parser(Class<? extends HttpPartParser> value) {
            this.parser = value;
            return this;
        }

        public Builder schema(Schema value) {
            this.schema = value;
            return this;
        }

        public Builder serializer(Class<? extends HttpPartSerializer> value) {
            this.serializer = value;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder on(String ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Class<?> ... value) {
            super.on((Class[])value);
            return this;
        }

        public Builder onClass(Class<?> ... value) {
            super.onClass((Class[])value);
            return this;
        }

        public Builder on(Method ... value) {
            super.on(value);
            return this;
        }

        public Builder on(Field ... value) {
            super.on(value);
            return this;
        }

        public Builder on(ClassInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder onClass(ClassInfo ... value) {
            super.onClass(value);
            return this;
        }

        public Builder on(FieldInfo ... value) {
            super.on(value);
            return this;
        }

        public Builder on(MethodInfo ... value) {
            super.on(value);
            return this;
        }
    }

    private static class Object
    extends AppliedOnClassAnnotationObject
    implements Query {
        private final String[] description;
        private final Class<? extends HttpPartParser> parser;
        private final Class<? extends HttpPartSerializer> serializer;
        private final String name;
        private final String value;
        private final String def;
        private final Schema schema;

        Object(Builder b) {
            super((AppliedAnnotationObject.BuilderT)b);
            this.description = (String[])CollectionUtils.copyOf((java.lang.Object[])b.description);
            this.name = b.name;
            this.parser = b.parser;
            this.schema = b.schema;
            this.serializer = b.serializer;
            this.value = b.value;
            this.def = b.def;
        }

        @Override
        public String def() {
            return this.def;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Class<? extends HttpPartParser> parser() {
            return this.parser;
        }

        @Override
        public Schema schema() {
            return this.schema;
        }

        @Override
        public Class<? extends HttpPartSerializer> serializer() {
            return this.serializer;
        }

        @Override
        public String value() {
            return this.value;
        }

        @Override
        public String[] description() {
            return this.description;
        }
    }

    @Documented
    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Inherited
    public static @interface Array {
        public Query[] value();
    }

    public static class Applier
    extends AnnotationApplier<Query, BeanContext.Builder> {
        public Applier(VarResolverSession vr) {
            super(Query.class, BeanContext.Builder.class, vr);
        }

        @Override
        public void apply(AnnotationInfo<Query> ai, BeanContext.Builder b) {
            Query a = (Query)ai.inner();
            if (CollectionUtils.isEmptyArray((java.lang.Object[])a.on()) && CollectionUtils.isEmptyArray((java.lang.Object[])a.onClass())) {
                return;
            }
            b.annotations(a);
        }
    }
}

