/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.json;

import java.io.Writer;
import org.apache.juneau.UriResolver;
import org.apache.juneau.commons.collections.KeywordSet;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.serializer.SerializerWriter;

public class JsonWriter
extends SerializerWriter {
    private static final AsciiSet encodedChars = AsciiSet.of((String)"\n\t\b\f\r'\"\\");
    private static final AsciiSet encodedChars2 = AsciiSet.of((String)"\n\t\b\f\r'\"\\/");
    private static final KeywordSet reservedWords = new KeywordSet(new String[]{"arguments", "break", "case", "catch", "class", "const", "continue", "debugger", "default", "delete", "do", "else", "enum", "eval", "export", "extends", "false", "finally", "for", "function", "if", "implements", "import", "in", "instanceof", "interface", "let", "new", "null", "package", "private", "protected", "public", "return", "static", "super", "switch", "this", "throw", "true", "try", "typeof", "var", "void", "while", "with", "undefined", "yield"});
    private static final AsciiSet validAttrChars = AsciiSet.create().ranges(new String[]{"a-z", "A-Z", "0-9"}).chars("_").build();
    private static final AsciiSet validFirstAttrChars = AsciiSet.create().ranges(new String[]{"a-z", "A-Z"}).chars("_").build();
    private final boolean simpleAttrs;
    private final boolean escapeSolidus;
    private final AsciiSet ec;

    protected JsonWriter(Writer out, boolean useWhitespace, int maxIndent, boolean escapeSolidus, char quoteChar, boolean simpleAttrs, boolean trimStrings, UriResolver uriResolver) {
        super(out, useWhitespace, maxIndent, trimStrings, quoteChar, uriResolver);
        this.simpleAttrs = simpleAttrs;
        this.escapeSolidus = escapeSolidus;
        this.ec = escapeSolidus ? encodedChars2 : encodedChars;
    }

    @Override
    public JsonWriter append(char c) {
        super.append(c);
        return this;
    }

    @Override
    public JsonWriter append(char[] value) {
        super.append(value);
        return this;
    }

    @Override
    public JsonWriter append(int indent, char c) {
        super.append(indent, c);
        return this;
    }

    @Override
    public JsonWriter append(int indent, String text) {
        super.append(indent, text);
        return this;
    }

    @Override
    public JsonWriter append(Object text) {
        super.append(text);
        return this;
    }

    @Override
    public JsonWriter append(String text) {
        super.append(text);
        return this;
    }

    @Override
    public JsonWriter appendIf(boolean b, char c) {
        super.appendIf(b, c);
        return this;
    }

    @Override
    public JsonWriter appendIf(boolean b, String text) {
        super.appendIf(b, text);
        return this;
    }

    @Override
    public JsonWriter appendln(int indent, String text) {
        super.appendln(indent, text);
        return this;
    }

    @Override
    public JsonWriter appendln(String text) {
        super.appendln(text);
        return this;
    }

    @Override
    public JsonWriter appendUri(Object value) {
        super.appendUri(value);
        return this;
    }

    public JsonWriter attr(String s) {
        boolean doConvert;
        if (this.trimStrings) {
            s = StringUtils.trim((String)s);
        }
        boolean bl = doConvert = !this.simpleAttrs;
        if (s == null) {
            s = "null";
            doConvert = false;
        } else {
            if (!doConvert) {
                char c;
                for (int i = 0; i < s.length() && !doConvert; doConvert |= !(i != 0 ? validAttrChars.contains(c) : validFirstAttrChars.contains(c)), ++i) {
                    c = s.charAt(i);
                }
            }
            if (!doConvert && (s.isEmpty() || reservedWords.contains(s))) {
                doConvert = true;
            }
        }
        if (doConvert) {
            this.stringValue(s);
        } else {
            this.w(s);
        }
        return this;
    }

    @Override
    public JsonWriter cr(int depth) {
        super.cr(depth);
        return this;
    }

    @Override
    public JsonWriter cre(int depth) {
        super.cre(depth);
        return this;
    }

    @Override
    public JsonWriter i(int indent) {
        super.i(indent);
        return this;
    }

    @Override
    public JsonWriter ie(int indent) {
        super.ie(indent);
        return this;
    }

    @Override
    public JsonWriter nl(int indent) {
        super.nl(indent);
        return this;
    }

    @Override
    public JsonWriter nlIf(boolean flag, int indent) {
        super.nlIf(flag, indent);
        return this;
    }

    @Override
    public JsonWriter q() {
        super.q();
        return this;
    }

    @Override
    public JsonWriter s() {
        super.s();
        return this;
    }

    public JsonWriter s(int indent) {
        if (indent <= this.maxIndent) {
            super.s();
        }
        return this;
    }

    @Override
    public JsonWriter sIf(boolean flag) {
        super.sIf(flag);
        return this;
    }

    public JsonWriter smi(int depth) {
        if (depth > this.maxIndent) {
            super.s();
        }
        return this;
    }

    public JsonWriter stringValue(String s) {
        int i;
        char c;
        if (s == null) {
            return this;
        }
        boolean doConvert = false;
        for (i = 0; i < s.length() && !doConvert; doConvert |= this.ec.contains(c), ++i) {
            c = s.charAt(i);
        }
        this.q();
        if (!doConvert) {
            this.w(s);
        } else {
            for (i = 0; i < s.length(); ++i) {
                c = s.charAt(i);
                if (this.ec.contains(c)) {
                    if (c == '\n') {
                        this.w('\\').w('n');
                        continue;
                    }
                    if (c == '\t') {
                        this.w('\\').w('t');
                        continue;
                    }
                    if (c == '\b') {
                        this.w('\\').w('b');
                        continue;
                    }
                    if (c == '\f') {
                        this.w('\\').w('f');
                        continue;
                    }
                    if (c == this.quoteChar) {
                        this.w('\\').w(this.quoteChar);
                        continue;
                    }
                    if (c == '\\') {
                        this.w('\\').w('\\');
                        continue;
                    }
                    if (c == '/' && this.escapeSolidus) {
                        this.w('\\').w('/');
                        continue;
                    }
                    if (c == '\r') continue;
                    this.w(c);
                    continue;
                }
                this.w(c);
            }
        }
        this.q();
        return this;
    }

    public SerializerWriter uriValue(Object uri) {
        return this.stringValue(this.uriResolver.resolve(uri));
    }

    @Override
    public JsonWriter w(char value) {
        super.w(value);
        return this;
    }

    @Override
    public JsonWriter w(String value) {
        super.w(value);
        return this;
    }
}

