/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Set;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Example
extends OpenApiElement {
    private String summary;
    private String description;
    private String externalValue;
    private Object value;

    public Example() {
    }

    public Example(Example copyFrom) {
        super(copyFrom);
        this.summary = copyFrom.summary;
        this.description = copyFrom.description;
        this.externalValue = copyFrom.externalValue;
        this.value = copyFrom.value;
    }

    public Example copy() {
        return new Example(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "externalValue" -> ConverterUtils.toType(this.getExternalValue(), type);
            case "summary" -> ConverterUtils.toType(this.getSummary(), type);
            case "value" -> ConverterUtils.toType(this.getValue(), type);
            default -> super.get(property, type);
        };
    }

    public String getDescription() {
        return this.description;
    }

    public String getExternalValue() {
        return this.externalValue;
    }

    public String getSummary() {
        return this.summary;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.description), "description").addIf(Utils.nn(this.externalValue), "externalValue").addIf(Utils.nn(this.summary), "summary").addIf(Utils.nn(this.value), "value").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public Example set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "description" -> this.setDescription(Utils.s(value));
            case "externalValue" -> this.setExternalValue(Utils.s(value));
            case "summary" -> this.setSummary(Utils.s(value));
            case "value" -> this.setValue(value);
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Example setDescription(String value) {
        this.description = value;
        return this;
    }

    public Example setExternalValue(String value) {
        this.externalValue = value;
        return this;
    }

    public Example setSummary(String value) {
        this.summary = value;
        return this;
    }

    public Example setValue(Object val) {
        this.value = val;
        return this;
    }

    @Override
    public Example strict() {
        super.strict();
        return this;
    }

    @Override
    public Example strict(Object value) {
        super.strict(value);
        return this;
    }
}

