/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Set;
import org.apache.juneau.bean.openapi3.OAuthFlow;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class SecuritySchemeInfo
extends OpenApiElement {
    private static final String[] VALID_IN = new String[]{"query", "header", "cookie"};
    private static final String[] VALID_TYPES = new String[]{"apiKey", "http", "oauth2", "openIdConnect"};
    private String type;
    private String description;
    private String name;
    private String in;
    private String scheme;
    private String bearerFormat;
    private String openIdConnectUrl;
    private OAuthFlow flows;

    public SecuritySchemeInfo() {
    }

    public SecuritySchemeInfo(SecuritySchemeInfo copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.in = copyFrom.in;
        this.description = copyFrom.description;
        this.type = copyFrom.type;
        this.scheme = copyFrom.scheme;
        this.bearerFormat = copyFrom.bearerFormat;
        this.openIdConnectUrl = copyFrom.openIdConnectUrl;
        this.flows = copyFrom.flows;
    }

    public SecuritySchemeInfo copy() {
        return new SecuritySchemeInfo(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "name" -> ConverterUtils.toType(this.getName(), type);
            case "in" -> ConverterUtils.toType(this.getIn(), type);
            case "description" -> ConverterUtils.toType(this.getDescription(), type);
            case "scheme" -> ConverterUtils.toType(this.getScheme(), type);
            case "flows" -> ConverterUtils.toType(this.getFlows(), type);
            case "bearerFormat" -> ConverterUtils.toType(this.getBearerFormat(), type);
            case "openIdConnectUrl" -> ConverterUtils.toType(this.getOpenIdConnectUrl(), type);
            case "type" -> ConverterUtils.toType(this.getType(), type);
            default -> super.get(property, type);
        };
    }

    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public OAuthFlow getFlows() {
        return this.flows;
    }

    public String getIn() {
        return this.in;
    }

    public String getName() {
        return this.name;
    }

    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public Set<String> keySet() {
        Set<String> s = CollectionUtils.setb(String.class).addIf(Utils.nn(this.bearerFormat), "bearerFormat").addIf(Utils.nn(this.description), "description").addIf(Utils.nn(this.flows), "flows").addIf(Utils.nn(this.in), "in").addIf(Utils.nn(this.name), "name").addIf(Utils.nn(this.openIdConnectUrl), "openIdConnectUrl").addIf(Utils.nn(this.scheme), "scheme").addIf(Utils.nn(this.type), "type").build();
        return new MultiSet<String>(s, super.keySet());
    }

    @Override
    public SecuritySchemeInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull("property", property);
        return switch (property) {
            case "bearerFormat" -> this.setBearerFormat(Utils.s(value));
            case "description" -> this.setDescription(Utils.s(value));
            case "flows" -> this.setFlows(ConverterUtils.toType(value, OAuthFlow.class));
            case "in" -> this.setIn(Utils.s(value));
            case "name" -> this.setName(Utils.s(value));
            case "openIdConnectUrl" -> this.setOpenIdConnectUrl(Utils.s(value));
            case "scheme" -> this.setScheme(Utils.s(value));
            case "type" -> this.setType(Utils.s(value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public SecuritySchemeInfo setBearerFormat(String value) {
        this.bearerFormat = value;
        return this;
    }

    public SecuritySchemeInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public SecuritySchemeInfo setFlows(OAuthFlow value) {
        this.flows = value;
        return this;
    }

    public SecuritySchemeInfo setIn(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_IN)) {
            throw ThrowableUtils.rex("Invalid value passed in to setIn(String).  Value=''{0}'', valid values=[{1}]", value, StringUtils.toCdl(VALID_IN));
        }
        this.in = value;
        return this;
    }

    public SecuritySchemeInfo setName(String value) {
        this.name = value;
        return this;
    }

    public SecuritySchemeInfo setOpenIdConnectUrl(String value) {
        this.openIdConnectUrl = value;
        return this;
    }

    public SecuritySchemeInfo setScheme(String value) {
        this.scheme = value;
        return this;
    }

    public SecuritySchemeInfo setType(String value) {
        if (this.isStrict() && !CollectionUtils.contains(value, VALID_TYPES)) {
            throw ThrowableUtils.rex("Invalid value passed in to setType(String).  Value=''{0}'', valid values=[{1}]", value, StringUtils.toCdl(VALID_TYPES));
        }
        this.type = value;
        return this;
    }

    @Override
    public SecuritySchemeInfo strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected SecuritySchemeInfo strict() {
        super.strict();
        return this;
    }
}

