/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3.ui;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanSession;
import org.apache.juneau.MediaType;
import org.apache.juneau.bean.html5.Div;
import org.apache.juneau.bean.html5.HtmlBuilder;
import org.apache.juneau.bean.html5.HtmlElement;
import org.apache.juneau.bean.html5.Select;
import org.apache.juneau.bean.html5.Table;
import org.apache.juneau.bean.html5.Td;
import org.apache.juneau.bean.openapi3.Contact;
import org.apache.juneau.bean.openapi3.ExternalDocumentation;
import org.apache.juneau.bean.openapi3.Info;
import org.apache.juneau.bean.openapi3.License;
import org.apache.juneau.bean.openapi3.OpenApi;
import org.apache.juneau.bean.openapi3.Operation;
import org.apache.juneau.bean.openapi3.Parameter;
import org.apache.juneau.bean.openapi3.Response;
import org.apache.juneau.bean.openapi3.SchemaInfo;
import org.apache.juneau.bean.openapi3.Tag;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.BeanStore;
import org.apache.juneau.cp.FileFinder;
import org.apache.juneau.swap.ObjectSwap;

public class OpenApiUI
extends ObjectSwap<OpenApi, Div> {
    static final FileFinder RESOURCES = (FileFinder)FileFinder.create(BeanStore.INSTANCE).cp(OpenApiUI.class, null, true).dir(",").caching(Boolean.getBoolean("RestContext.disableClasspathResourceCaching.b") ? -1L : 1000000L).build();
    private static final Set<String> STANDARD_METHODS = CollectionUtils.set("get", "put", "post", "delete", "options", "head", "patch", "trace");

    private static void addOperationIfTagMatches(Div tagBlockContents, Session s, String path, String method, Operation op, Tag t) {
        if (t == null && (op.getTags() == null || op.getTags().isEmpty()) || Utils.nn(t) && Utils.nn(op.getTags()) && op.getTags().contains(t.getName())) {
            tagBlockContents.child(OpenApiUI.opBlock(s, path, method, op));
        }
    }

    private static Div examples(Session s, Parameter pi) {
        JsonMap m = new JsonMap();
        try {
            SchemaInfo si = pi.getSchema();
            if (Utils.nn(si)) {
                m.put("model", (Object)si.copy().resolveRefs(s.openApi, new ArrayDeque<String>(), s.resolveRefsMaxDepth));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return OpenApiUI.examplesDiv(m);
    }

    private static Div examples(Session s, Response ri) {
        JsonMap m = new JsonMap();
        try {
            Map<String, org.apache.juneau.bean.openapi3.MediaType> content = ri.getContent();
            if (Utils.nn(content)) {
                content.forEach((mediaType, mediaTypeObj) -> {
                    if (Utils.nn(mediaTypeObj.getSchema())) {
                        try {
                            SchemaInfo schema = mediaTypeObj.getSchema().copy().resolveRefs(s.openApi, new ArrayDeque<String>(), s.resolveRefsMaxDepth);
                            m.put((String)mediaType, (Object)schema);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (m.isEmpty()) {
            return null;
        }
        return OpenApiUI.examplesDiv(m);
    }

    private static Div examplesDiv(JsonMap m) {
        if (m.isEmpty()) {
            return null;
        }
        Select select = null;
        if (m.size() > 1) {
            select = HtmlBuilder.select().onchange("selectExample(this)")._class("example-select");
        }
        Div div = HtmlBuilder.div(select)._class("examples");
        if (Utils.nn(select)) {
            select.child(HtmlBuilder.option("model", "model"));
        }
        div.child(HtmlBuilder.div(m.remove("model"))._class("model active").attr("data-name", "model"));
        Select select2 = select;
        m.forEach((k, v) -> {
            if (Utils.nn(select2)) {
                select2.child(HtmlBuilder.option(k, k));
            }
            div.child(HtmlBuilder.div(v.toString().replace("\\n", "\n"))._class("example").attr("data-name", k));
        });
        return div;
    }

    private static Table header(Session s) {
        Table table = HtmlBuilder.table()._class("header");
        Info info = s.openApi.getInfo();
        if (Utils.nn(info)) {
            String child;
            ExternalDocumentation ed;
            License l;
            Contact c;
            if (Utils.nn(info.getDescription())) {
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Description:"), HtmlBuilder.td(OpenApiUI.toBRL(info.getDescription()))));
            }
            if (Utils.nn(info.getVersion())) {
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Version:"), HtmlBuilder.td(info.getVersion())));
            }
            if (Utils.nn(c = info.getContact())) {
                Table t2 = HtmlBuilder.table();
                if (Utils.nn(c.getName())) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("Name:"), HtmlBuilder.td(c.getName())));
                }
                if (Utils.nn(c.getUrl())) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("URL:"), HtmlBuilder.td(HtmlBuilder.a(c.getUrl(), c.getUrl()))));
                }
                if (Utils.nn(c.getEmail())) {
                    t2.child(HtmlBuilder.tr(HtmlBuilder.th("Email:"), HtmlBuilder.td(HtmlBuilder.a("mailto:" + c.getEmail(), c.getEmail()))));
                }
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Contact:"), HtmlBuilder.td(t2)));
            }
            if (Utils.nn(l = info.getLicense())) {
                Object content = Utils.nn(l.getName()) ? l.getName() : l.getUrl();
                String child2 = Utils.nn(l.getUrl()) ? HtmlBuilder.a(l.getUrl(), content) : l.getName();
                table.child(HtmlBuilder.tr(HtmlBuilder.th("License:"), HtmlBuilder.td(child2)));
            }
            if (Utils.nn(ed = s.openApi.getExternalDocs())) {
                Object content = Utils.nn(ed.getDescription()) ? ed.getDescription() : ed.getUrl();
                child = Utils.nn(ed.getUrl()) ? HtmlBuilder.a(ed.getUrl(), content) : ed.getDescription();
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Docs:"), HtmlBuilder.td(child)));
            }
            if (Utils.nn(info.getTermsOfService())) {
                String tos = info.getTermsOfService();
                child = StringUtils.isUri(tos) ? HtmlBuilder.a(tos, tos) : tos;
                table.child(HtmlBuilder.tr(HtmlBuilder.th("Terms of Service:"), HtmlBuilder.td(child)));
            }
        }
        return table;
    }

    private static Div headers(Response ri) {
        if (ri.getHeaders() == null) {
            return null;
        }
        Table sectionTable = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Name"), HtmlBuilder.th("Description"), HtmlBuilder.th("Schema")))._class("section-table");
        Div headers = HtmlBuilder.div(HtmlBuilder.div("Headers:")._class("section-name"), sectionTable)._class("headers");
        ri.getHeaders().forEach((k, v) -> sectionTable.child(HtmlBuilder.tr(HtmlBuilder.td(k)._class("name"), HtmlBuilder.td(OpenApiUI.toBRL(v.getDescription()))._class("description"), HtmlBuilder.td(v.asMap().keepAll("type", "format", "items", "collectionFormat", "default", "maximum", "exclusiveMaximum", "minimum", "exclusiveMinimum", "maxLength", "minLength", "pattern", "maxItems", "minItems", "uniqueItems", "enum", "multipleOf")))));
        return headers;
    }

    private static Div modelBlock(String modelName, SchemaInfo model) {
        return HtmlBuilder.div()._class("op-block op-block-closed model").children(OpenApiUI.modelBlockSummary(modelName, model), HtmlBuilder.div(model)._class("op-block-contents"));
    }

    private static HtmlElement modelBlockSummary(String modelName, SchemaInfo model) {
        return HtmlBuilder.div()._class("op-block-summary").onclick("toggleOpBlock(this)").children(HtmlBuilder.span(modelName)._class("method-button"), Utils.nn(model.getDescription()) ? HtmlBuilder.span(OpenApiUI.toBRL(model.getDescription()))._class("summary") : null);
    }

    private static Div modelsBlockContents(Session s) {
        Div modelBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        if (Utils.nn(s.openApi.getComponents()) && Utils.nn(s.openApi.getComponents().getSchemas())) {
            s.openApi.getComponents().getSchemas().forEach((k, v) -> modelBlockContents.child(OpenApiUI.modelBlock(k, v)));
        }
        return modelBlockContents;
    }

    private static HtmlElement modelsBlockSummary() {
        return HtmlBuilder.div()._class("tag-block-summary").onclick("toggleTagBlock(this)").children(HtmlBuilder.span("Models")._class("name"));
    }

    private static Div opBlock(Session s, String path, String opName, Operation op) {
        String opClass;
        String string = opClass = Utils.nn(op.getDeprecated()) && op.getDeprecated() != false ? "deprecated" : opName.toLowerCase();
        if (!(Utils.nn(op.getDeprecated()) && op.getDeprecated().booleanValue() || STANDARD_METHODS.contains(opClass))) {
            opClass = "other";
        }
        return HtmlBuilder.div()._class("op-block op-block-closed " + opClass).children(OpenApiUI.opBlockSummary(path, opName, op), HtmlBuilder.div(OpenApiUI.tableContainer(s, op))._class("op-block-contents"));
    }

    private static HtmlElement opBlockSummary(String path, String opName, Operation op) {
        return HtmlBuilder.div()._class("op-block-summary").onclick("toggleOpBlock(this)").children(HtmlBuilder.span(opName.toUpperCase())._class("method-button"), HtmlBuilder.span(path)._class("path"), Utils.nn(op.getSummary()) ? HtmlBuilder.span(op.getSummary())._class("summary") : null);
    }

    private static Div tableContainer(Session s, Operation op) {
        Div tableContainer = HtmlBuilder.div()._class("table-container");
        if (Utils.nn(op.getDescription())) {
            tableContainer.child(HtmlBuilder.div(OpenApiUI.toBRL(op.getDescription()))._class("op-block-description"));
        }
        if (Utils.nn(op.getParameters())) {
            tableContainer.child(HtmlBuilder.div(HtmlBuilder.h4("Parameters")._class("title"))._class("op-block-section-header"));
            Table parameters = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Name")._class("parameter-key"), HtmlBuilder.th("Description")._class("parameter-key")))._class("parameters");
            op.getParameters().forEach(x -> {
                String piName = x.getName();
                boolean required = Utils.nn(x.getRequired()) && x.getRequired() != false;
                Td parameterKey = HtmlBuilder.td(HtmlBuilder.div(piName)._class("name" + (required ? " required" : "")), required ? HtmlBuilder.div("required")._class("requiredlabel") : null, Utils.nn(x.getSchema()) ? HtmlBuilder.div(x.getSchema().getType())._class("type") : null, HtmlBuilder.div("(" + x.getIn() + ")")._class("in"))._class("parameter-key");
                Td parameterValue = HtmlBuilder.td(HtmlBuilder.div(OpenApiUI.toBRL(x.getDescription()))._class("description"), OpenApiUI.examples(s, x))._class("parameter-value");
                parameters.child(HtmlBuilder.tr(parameterKey, parameterValue));
            });
            tableContainer.child(parameters);
        }
        if (Utils.nn(op.getResponses())) {
            tableContainer.child(HtmlBuilder.div(HtmlBuilder.h4("Responses")._class("title"))._class("op-block-section-header"));
            Table responses = HtmlBuilder.table(HtmlBuilder.tr(HtmlBuilder.th("Code")._class("response-key"), HtmlBuilder.th("Description")._class("response-key")))._class("responses");
            tableContainer.child(responses);
            op.getResponses().forEach((k, v) -> {
                Td code = HtmlBuilder.td(k)._class("response-key");
                Td codeValue = HtmlBuilder.td(HtmlBuilder.div(OpenApiUI.toBRL(v.getDescription()))._class("description"), OpenApiUI.examples(s, v), OpenApiUI.headers(v))._class("response-value");
                responses.child(HtmlBuilder.tr(code, codeValue));
            });
        }
        return tableContainer;
    }

    private static Div tagBlockContents(Session s, Tag t) {
        Div tagBlockContents = HtmlBuilder.div()._class("tag-block-contents");
        if (Utils.nn(s.openApi.getPaths())) {
            s.openApi.getPaths().forEach((path, pathItem) -> {
                if (Utils.nn(pathItem.getGet())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "get", pathItem.getGet(), t);
                }
                if (Utils.nn(pathItem.getPut())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "put", pathItem.getPut(), t);
                }
                if (Utils.nn(pathItem.getPost())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "post", pathItem.getPost(), t);
                }
                if (Utils.nn(pathItem.getDelete())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "delete", pathItem.getDelete(), t);
                }
                if (Utils.nn(pathItem.getOptions())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "options", pathItem.getOptions(), t);
                }
                if (Utils.nn(pathItem.getHead())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "head", pathItem.getHead(), t);
                }
                if (Utils.nn(pathItem.getPatch())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "patch", pathItem.getPatch(), t);
                }
                if (Utils.nn(pathItem.getTrace())) {
                    OpenApiUI.addOperationIfTagMatches(tagBlockContents, s, path, "trace", pathItem.getTrace(), t);
                }
            });
        }
        return tagBlockContents;
    }

    private static HtmlElement tagBlockSummary(Tag t) {
        ExternalDocumentation ed = t.getExternalDocs();
        URI content = Utils.nn(ed) && Utils.nn(ed.getDescription()) ? ed.getDescription() : (Utils.nn(ed) ? ed.getUrl() : null);
        return HtmlBuilder.div()._class("tag-block-summary").onclick("toggleTagBlock(this)").children(HtmlBuilder.span(t.getName())._class("name"), HtmlBuilder.span(OpenApiUI.toBRL(t.getDescription()))._class("description"), Utils.nn(ed) && Utils.nn(ed.getUrl()) ? HtmlBuilder.span(HtmlBuilder.a(ed.getUrl(), content))._class("extdocs") : null);
    }

    private static List<Object> toBRL(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(44) == -1) {
            return Collections.singletonList(s);
        }
        List<Object> l = CollectionUtils.list(new Object[0]);
        String[] sa = s.split("\n");
        for (int i = 0; i < sa.length; ++i) {
            if (i > 0) {
                l.add(HtmlBuilder.br());
            }
            l.add(sa[i]);
        }
        return l;
    }

    @Override
    public MediaType[] forMediaTypes() {
        return CollectionUtils.a(MediaType.HTML);
    }

    @Override
    public Div swap(BeanSession beanSession, OpenApi openApi) throws Exception {
        Session s = new Session(openApi);
        String css = RESOURCES.getString("files/htdocs/styles/OpenApiUI.css", null).orElse(null);
        if (css == null) {
            css = RESOURCES.getString("OpenApiUI.css", null).orElse(null);
        }
        Div outer = HtmlBuilder.div(HtmlBuilder.style((Object)css), HtmlBuilder.script("text/javascript", RESOURCES.getString("OpenApiUI.js", null).orElse(null)), OpenApiUI.header(s))._class("openapi-ui");
        outer.child(HtmlBuilder.div()._class("tag-block tag-block-open").children(OpenApiUI.tagBlockContents(s, null)));
        if (Utils.nn(s.openApi.getTags())) {
            s.openApi.getTags().forEach(x -> {
                Div tagBlock = HtmlBuilder.div()._class("tag-block tag-block-open").children(OpenApiUI.tagBlockSummary(x), OpenApiUI.tagBlockContents(s, x));
                outer.child(tagBlock);
            });
        }
        if (Utils.nn(s.openApi.getComponents()) && Utils.nn(s.openApi.getComponents().getSchemas())) {
            Div modelBlock = HtmlBuilder.div()._class("tag-block").children(OpenApiUI.modelsBlockSummary(), OpenApiUI.modelsBlockContents(s));
            outer.child(modelBlock);
        }
        return outer;
    }

    private static class Session {
        final int resolveRefsMaxDepth;
        final OpenApi openApi;

        Session(OpenApi openApi) {
            this.openApi = openApi.copy();
            this.resolveRefsMaxDepth = 1;
        }
    }
}

