/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.openapi3;

import java.util.Collection;
import java.util.Set;
import org.apache.juneau.bean.openapi3.OAuthFlow;
import org.apache.juneau.bean.openapi3.OpenApiElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class SecuritySchemeInfo
extends OpenApiElement {
    private static final String[] VALID_IN = new String[]{"query", "header", "cookie"};
    private static final String[] VALID_TYPES = new String[]{"apiKey", "http", "oauth2", "openIdConnect"};
    private String type;
    private String description;
    private String name;
    private String in;
    private String scheme;
    private String bearerFormat;
    private String openIdConnectUrl;
    private OAuthFlow flows;

    public SecuritySchemeInfo() {
    }

    public SecuritySchemeInfo(SecuritySchemeInfo copyFrom) {
        super(copyFrom);
        this.name = copyFrom.name;
        this.in = copyFrom.in;
        this.description = copyFrom.description;
        this.type = copyFrom.type;
        this.scheme = copyFrom.scheme;
        this.bearerFormat = copyFrom.bearerFormat;
        this.openIdConnectUrl = copyFrom.openIdConnectUrl;
        this.flows = copyFrom.flows;
    }

    public SecuritySchemeInfo copy() {
        return new SecuritySchemeInfo(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "name" -> ConverterUtils.toType((Object)this.getName(), type);
            case "in" -> ConverterUtils.toType((Object)this.getIn(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "scheme" -> ConverterUtils.toType((Object)this.getScheme(), type);
            case "flows" -> ConverterUtils.toType((Object)this.getFlows(), type);
            case "bearerFormat" -> ConverterUtils.toType((Object)this.getBearerFormat(), type);
            case "openIdConnectUrl" -> ConverterUtils.toType((Object)this.getOpenIdConnectUrl(), type);
            case "type" -> ConverterUtils.toType((Object)this.getType(), type);
            default -> super.get(property, type);
        });
    }

    public String getBearerFormat() {
        return this.bearerFormat;
    }

    public String getDescription() {
        return this.description;
    }

    public OAuthFlow getFlows() {
        return this.flows;
    }

    public String getIn() {
        return this.in;
    }

    public String getName() {
        return this.name;
    }

    public String getOpenIdConnectUrl() {
        return this.openIdConnectUrl;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.nn((Object)this.bearerFormat), (Object)"bearerFormat").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.flows), (Object)"flows").addIf(Utils.nn((Object)this.in), (Object)"in").addIf(Utils.nn((Object)this.name), (Object)"name").addIf(Utils.nn((Object)this.openIdConnectUrl), (Object)"openIdConnectUrl").addIf(Utils.nn((Object)this.scheme), (Object)"scheme").addIf(Utils.nn((Object)this.type), (Object)"type").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public SecuritySchemeInfo set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "bearerFormat" -> this.setBearerFormat(Utils.s((Object)value));
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "flows" -> this.setFlows((OAuthFlow)ConverterUtils.toType((Object)value, OAuthFlow.class));
            case "in" -> this.setIn(Utils.s((Object)value));
            case "name" -> this.setName(Utils.s((Object)value));
            case "openIdConnectUrl" -> this.setOpenIdConnectUrl(Utils.s((Object)value));
            case "scheme" -> this.setScheme(Utils.s((Object)value));
            case "type" -> this.setType(Utils.s((Object)value));
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public SecuritySchemeInfo setBearerFormat(String value) {
        this.bearerFormat = value;
        return this;
    }

    public SecuritySchemeInfo setDescription(String value) {
        this.description = value;
        return this;
    }

    public SecuritySchemeInfo setFlows(OAuthFlow value) {
        this.flows = value;
        return this;
    }

    public SecuritySchemeInfo setIn(String value) {
        if (this.isStrict() && !CollectionUtils.contains((Object)value, (Object[])VALID_IN)) {
            throw ThrowableUtils.rex((String)"Invalid value passed in to setIn(String).  Value=''{0}'', valid values=[{1}]", (Object[])new Object[]{value, StringUtils.toCdl((Object)VALID_IN)});
        }
        this.in = value;
        return this;
    }

    public SecuritySchemeInfo setName(String value) {
        this.name = value;
        return this;
    }

    public SecuritySchemeInfo setOpenIdConnectUrl(String value) {
        this.openIdConnectUrl = value;
        return this;
    }

    public SecuritySchemeInfo setScheme(String value) {
        this.scheme = value;
        return this;
    }

    public SecuritySchemeInfo setType(String value) {
        if (this.isStrict() && !CollectionUtils.contains((Object)value, (Object[])VALID_TYPES)) {
            throw ThrowableUtils.rex((String)"Invalid value passed in to setType(String).  Value=''{0}'', valid values=[{1}]", (Object[])new Object[]{value, StringUtils.toCdl((Object)VALID_TYPES)});
        }
        this.type = value;
        return this;
    }

    @Override
    public SecuritySchemeInfo strict(Object value) {
        super.strict(value);
        return this;
    }

    @Override
    protected SecuritySchemeInfo strict() {
        super.strict();
        return this;
    }
}

