/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.console;

import java.io.PrintWriter;
import java.util.Map;
import java.util.Scanner;
import org.apache.juneau.collections.Args;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.cp.Messages;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.microservice.console.ConsoleCommand;

public class HelpCommand
extends ConsoleCommand {
    private final Messages mb = Messages.of(HelpCommand.class, (String)"Messages");

    @Override
    public boolean execute(Scanner in, PrintWriter out, Args args) throws Exception {
        Map<String, ConsoleCommand> commands = Microservice.getInstance().getConsoleCommands();
        if (args.size() == 1) {
            out.println(this.mb.getString("ListOfAvailableCommands"));
            commands.forEach((k, v) -> out.append("\t").append(v.getName()).append(" -- ").append(HelpCommand.indent(v.getInfo())).println());
            out.println();
        } else {
            ConsoleCommand cc = commands.get(args.getArg(1));
            if (cc == null) {
                out.println(this.mb.getString("CommandNotFound"));
            } else {
                String info = cc.getInfo();
                String synopsis = cc.getSynopsis();
                String description = cc.getDescription();
                String examples = cc.getExamples();
                out.append(this.mb.getString("NAME")).append("\n\t").append(cc.getName()).append((CharSequence)(info == null ? "" : " -- " + HelpCommand.indent(info))).println();
                if (Utils.nn((Object)synopsis)) {
                    out.append('\n').append(this.mb.getString("SYNOPSIS")).append("\n\t").append(HelpCommand.indent(synopsis)).println();
                }
                if (Utils.nn((Object)description)) {
                    out.append('\n').append(this.mb.getString("DESCRIPTION")).append("\n\t").append(HelpCommand.indent(description)).println();
                }
                if (Utils.nn((Object)examples)) {
                    out.append('\n').append(this.mb.getString("EXAMPLES")).append("\n\t").append(HelpCommand.indent(examples)).println();
                }
            }
        }
        return false;
    }

    @Override
    public String getDescription() {
        return this.mb.getString("description");
    }

    @Override
    public String getExamples() {
        return this.mb.getString("examples");
    }

    @Override
    public String getInfo() {
        return this.mb.getString("info");
    }

    @Override
    public String getName() {
        return "help";
    }

    @Override
    public String getSynopsis() {
        return "help [command]";
    }

    private static String indent(String in) {
        if (in == null) {
            return "";
        }
        return in.replaceAll("\n", "\n\t");
    }
}

