/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.Schema;
import org.apache.juneau.annotation.SchemaAnnotation;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.commons.lang.Value;
import org.apache.juneau.commons.reflect.AnnotationInfo;
import org.apache.juneau.commons.reflect.AnnotationProvider;
import org.apache.juneau.commons.reflect.AnnotationTraversal;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.HeaderAnnotation;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializer;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.Rest;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.httppart.RequestHeaders;

public class HeaderArg
implements RestOpArg {
    private static final AnnotationProvider AP = AnnotationProvider.INSTANCE;
    private final HttpPartParser partParser;
    private final HttpPartSchema schema;
    private final boolean multi;
    private final String name;
    private final String def;
    private final ClassInfo type;

    public static HeaderArg create(ParameterInfo paramInfo, AnnotationWorkList annotations) {
        if (!paramInfo.getParameterType().is(Value.class) && AP.has(Header.class, paramInfo, new AnnotationTraversal[0])) {
            return new HeaderArg(paramInfo, annotations);
        }
        return null;
    }

    private static Header getMergedHeader(ParameterInfo pi, String paramName) {
        ClassInfo declaringClass = pi.getMethod().getDeclaringClass();
        if (declaringClass == null) {
            return null;
        }
        Rest restAnnotation = declaringClass.getAnnotations(Rest.class).findFirst().map(AnnotationInfo::inner).orElse(null);
        if (restAnnotation == null) {
            return null;
        }
        Header classLevelHeader = null;
        for (Header h : restAnnotation.headerParams()) {
            String hName = StringUtils.firstNonEmpty((String[])new String[]{h.name(), h.value()});
            if (!paramName.equals(hName)) continue;
            classLevelHeader = h;
            break;
        }
        if (classLevelHeader == null) {
            return null;
        }
        Header paramHeader = AP.find(Header.class, pi, new AnnotationTraversal[0]).stream().findFirst().map(AnnotationInfo::inner).orElse(null);
        if (paramHeader == null) {
            return classLevelHeader;
        }
        return HeaderArg.mergeAnnotations(classLevelHeader, paramHeader);
    }

    private static Header mergeAnnotations(Header classLevel, Header paramLevel) {
        return HeaderAnnotation.create().name(StringUtils.firstNonEmpty((String[])new String[]{paramLevel.name(), paramLevel.value(), classLevel.name(), classLevel.value()})).value(StringUtils.firstNonEmpty((String[])new String[]{paramLevel.value(), paramLevel.name(), classLevel.value(), classLevel.name()})).def(StringUtils.firstNonEmpty((String[])new String[]{paramLevel.def(), classLevel.def()})).description(paramLevel.description().length > 0 ? paramLevel.description() : classLevel.description()).parser(paramLevel.parser() != HttpPartParser.Void.class ? paramLevel.parser() : classLevel.parser()).serializer(paramLevel.serializer() != HttpPartSerializer.Void.class ? paramLevel.serializer() : classLevel.serializer()).schema(HeaderArg.mergeSchemas(classLevel.schema(), paramLevel.schema())).build();
    }

    private static Schema mergeSchemas(Schema classLevel, Schema paramLevel) {
        if (!SchemaAnnotation.empty((Schema)paramLevel)) {
            return paramLevel;
        }
        return classLevel;
    }

    protected HeaderArg(ParameterInfo pi, AnnotationWorkList annotations) {
        this.name = (String)HeaderAnnotation.findName((ParameterInfo)pi).orElseThrow(() -> new ArgException(pi, "@Header used without name or value", new Object[0]));
        Header mergedHeader = HeaderArg.getMergedHeader(pi, this.name);
        this.def = Utils.nn((Object)mergedHeader) && !mergedHeader.def().isEmpty() ? mergedHeader.def() : (String)HeaderAnnotation.findDef((ParameterInfo)pi).orElse(null);
        this.type = pi.getParameterType();
        this.schema = Utils.nn((Object)mergedHeader) ? HttpPartSchema.create((Annotation)mergedHeader) : HttpPartSchema.create(Header.class, (ParameterInfo)pi);
        Class pp = this.schema.getParser();
        this.partParser = Utils.nn((Object)pp) ? (HttpPartParser)HttpPartParser.creator().type(pp).apply(annotations).create() : null;
        boolean bl = this.multi = this.schema.getCollectionFormat() == HttpPartCollectionFormat.MULTI;
        if (this.multi && !this.type.isCollectionOrArray()) {
            throw new ArgException(pi, "Use of multipart flag on @Header parameter that is not an array or Collection", new Object[0]);
        }
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        RestRequest req = opSession.getRequest();
        HttpPartParserSession ps = this.partParser == null ? req.getPartParserSession() : this.partParser.getPartSession();
        RequestHeaders rh = req.getHeaders();
        BeanSession bs = req.getBeanSession();
        ClassMeta cm = bs.getClassMeta(this.type.innerType(), new Type[0]);
        if (this.multi) {
            List c = cm.isArray() ? CollectionUtils.list((Object[])new Object[0]) : (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new JsonList());
            rh.stream(this.name).map(x -> x.parser(ps).schema(this.schema).as(cm.getElementType()).orElse(null)).forEach(x -> c.add(x));
            return cm.isArray() ? CollectionUtils.toArray((Collection)c, (Class)cm.getElementType().inner()) : c;
        }
        if (cm.isMapOrBean() && StringUtils.isOneOf((String)this.name, (String[])new String[]{"*", ""})) {
            JsonMap m = new JsonMap();
            rh.forEach(x -> m.put(x.getName(), x.parser(ps).schema(this.schema == null ? null : this.schema.getProperty(x.getName())).as(cm.getValueType()).orElse(null)));
            return req.getBeanSession().convertToType((Object)m, cm);
        }
        return rh.getLast(this.name).parser(ps).schema(this.schema).def(this.def).as(this.type.innerType(), new Type[0]).orElse(null);
    }
}

